/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.blocks.tileentities.init.TileEntityInit;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class TransitoryTunnelTile
extends TileEntity
implements ITickableTileEntity {
    private int duration = 20;
    private int age;
    private BlockState previousBlockState = Blocks.field_150350_a.func_176223_P();

    public TransitoryTunnelTile() {
        super((TileEntityType)TileEntityInit.TRANSITORY_TUNNEL.get());
    }

    public void setDurationAndPreviousState(int duration, BlockState previous) {
        this.duration = duration;
        this.previousBlockState = previous;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.age;
        if (this.age > this.duration) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.previousBlockState, 2);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("age", this.age);
        nbt.func_74778_a("blockState", BlockStateParser.func_197247_a((BlockState)this.previousBlockState));
        compound.func_218657_a("tunnelData", (INBT)nbt);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("tunnelData")) {
            CompoundNBT nbt = compound.func_74775_l("tunnelData");
            if (nbt.func_74764_b("duration")) {
                this.duration = nbt.func_74762_e("duration");
            }
            if (nbt.func_74764_b("age")) {
                this.age = nbt.func_74762_e("age");
            }
            if (nbt.func_74764_b("blockState")) {
                StringReader sr = new StringReader(nbt.func_74779_i("blockState"));
                try {
                    this.previousBlockState = new BlockStateParser(sr, true).func_197243_a(true).func_197249_b();
                }
                catch (CommandSyntaxException e) {
                    this.previousBlockState = Blocks.field_150350_a.func_176223_P();
                    e.printStackTrace();
                }
            }
            if (this.previousBlockState == null) {
                this.previousBlockState = Blocks.field_150350_a.func_176223_P();
            }
        }
    }
}

