/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.ManaAndArtifice;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.sorcery.TransitoryTileBlock;
import com.ma.blocks.tileentities.init.TileEntityInit;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class TransitoryTile
extends TileEntity
implements ITickableTileEntity {
    private float topFaceAlpha = 0.0f;
    private boolean wasSteppedOn = false;
    private byte neighborMatrix = 0;
    private int age = 0;

    public TransitoryTile(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public TransitoryTile() {
        super((TileEntityType)TileEntityInit.TRANSITORY_TILE.get());
    }

    public void func_73660_a() {
        ++this.age;
        if (this.field_145850_b.field_72995_K) {
            this.topFaceAlpha = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a())).size() > 0 ? 1.0f : (this.topFaceAlpha -= 0.05f);
            if (!this.wasSteppedOn && this.topFaceAlpha > 0.0f) {
                this.particleBurst();
            }
            this.wasSteppedOn = this.topFaceAlpha > 0.0f;
            for (Direction d : Direction.values()) {
                if (this.hasNeighborOnSide(d)) continue;
                this.SpawnParticlesForFace(this.func_174877_v(), d);
            }
        } else if (this.age > (Integer)this.func_195044_w().func_177229_b((Property)TransitoryTileBlock.DURATION) * 20) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private void SpawnParticlesForFace(BlockPos pos, Direction face) {
        if (ManaAndArtifice.instance.proxy.isGamePaused()) {
            return;
        }
        Vector3d offset = null;
        Random rand = this.field_145850_b.field_73012_v;
        switch (face) {
            case DOWN: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                        offset = new Vector3d(rand.nextBoolean() ? 1.0 : 0.0, 0.0, rand.nextDouble());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.EAST)) {
                        offset = new Vector3d(1.0, 0.0, rand.nextDouble());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.WEST)) break;
                    offset = new Vector3d(0.0, 0.0, rand.nextDouble());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vector3d(rand.nextDouble(), 0.0, rand.nextBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vector3d(rand.nextDouble(), 0.0, 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vector3d(rand.nextDouble(), 0.0, 1.0);
                break;
            }
            case EAST: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vector3d(1.0, rand.nextBoolean() ? 1.0 : 0.0, rand.nextDouble());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vector3d(1.0, 1.0, rand.nextDouble());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vector3d(1.0, 0.0, rand.nextDouble());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vector3d(1.0, rand.nextDouble(), rand.nextBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vector3d(1.0, rand.nextDouble(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vector3d(1.0, rand.nextDouble(), 1.0);
                break;
            }
            case WEST: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vector3d(0.0, rand.nextBoolean() ? 1.0 : 0.0, rand.nextDouble());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vector3d(0.0, 1.0, rand.nextDouble());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vector3d(0.0, 0.0, rand.nextDouble());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vector3d(0.0, rand.nextDouble(), rand.nextBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vector3d(0.0, rand.nextDouble(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vector3d(0.0, rand.nextDouble(), 1.0);
                break;
            }
            case NORTH: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vector3d(rand.nextDouble(), rand.nextBoolean() ? 1.0 : 0.0, 0.0);
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vector3d(rand.nextDouble(), 1.0, 0.0);
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vector3d(rand.nextDouble(), 0.0, 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                    offset = new Vector3d(rand.nextBoolean() ? 1.0 : 0.0, rand.nextDouble(), 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST)) {
                    offset = new Vector3d(1.0, rand.nextDouble(), 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.WEST)) break;
                offset = new Vector3d(0.0, rand.nextDouble(), 0.0);
                break;
            }
            case SOUTH: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.UP) && !this.hasNeighborOnSide(Direction.DOWN)) {
                        offset = new Vector3d(rand.nextDouble(), rand.nextBoolean() ? 1.0 : 0.0, 1.0);
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.UP)) {
                        offset = new Vector3d(rand.nextDouble(), 1.0, 1.0);
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.DOWN)) break;
                    offset = new Vector3d(rand.nextDouble(), 0.0, 1.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                    offset = new Vector3d(rand.nextBoolean() ? 1.0 : 0.0, rand.nextDouble(), 1.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.EAST)) {
                    offset = new Vector3d(1.0, rand.nextDouble(), 1.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.WEST)) break;
                offset = new Vector3d(0.0, rand.nextDouble(), 1.0);
                break;
            }
            case UP: {
                if (rand.nextBoolean()) {
                    if (!this.hasNeighborOnSide(Direction.EAST) && !this.hasNeighborOnSide(Direction.WEST)) {
                        offset = new Vector3d(rand.nextBoolean() ? 1.0 : 0.0, 1.0, rand.nextDouble());
                        break;
                    }
                    if (!this.hasNeighborOnSide(Direction.EAST)) {
                        offset = new Vector3d(1.0, 1.0, rand.nextDouble());
                        break;
                    }
                    if (this.hasNeighborOnSide(Direction.WEST)) break;
                    offset = new Vector3d(0.0, 1.0, rand.nextDouble());
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH) && !this.hasNeighborOnSide(Direction.SOUTH)) {
                    offset = new Vector3d(rand.nextDouble(), 1.0, rand.nextBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (!this.hasNeighborOnSide(Direction.NORTH)) {
                    offset = new Vector3d(rand.nextDouble(), 1.0, 0.0);
                    break;
                }
                if (this.hasNeighborOnSide(Direction.SOUTH)) break;
                offset = new Vector3d(rand.nextDouble(), 1.0, 1.0);
            }
        }
        if (offset != null) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())), (double)pos.func_177958_n() + offset.field_72450_a, (double)pos.func_177956_o() + offset.field_72448_b, (double)pos.func_177952_p() + offset.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    public void setNeighborOnSide(Direction side) {
        if (side != null) {
            this.neighborMatrix = (byte)(this.neighborMatrix | 1 << side.ordinal());
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public void clearNeighborOnSide(Direction side) {
        if (side != null) {
            this.neighborMatrix = (byte)(this.neighborMatrix & ~(1 << side.ordinal()));
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public boolean hasNeighborOnSide(Direction side) {
        if (side == null) {
            return false;
        }
        byte value = (byte)(1 << side.ordinal());
        return (this.neighborMatrix & value) != 0;
    }

    public float topFaceAlpha() {
        return this.topFaceAlpha;
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        CompoundNBT data = super.func_189515_b(p_189515_1_);
        data.func_74774_a("neighbors", this.neighborMatrix);
        return data;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT data) {
        super.func_230337_a_(p_230337_1_, data);
        if (data.func_74764_b("neighbors")) {
            this.neighborMatrix = data.func_74771_c("neighbors");
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        data.func_74774_a("neighbors", this.neighborMatrix);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        if (data.func_74764_b("neighbors")) {
            this.neighborMatrix = data.func_74771_c("neighbors");
        }
    }

    private void particleBurst() {
        float velocityMod = 0.2f;
        for (int i = 0; i < 5; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), (double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + Math.random(), (double)this.field_174879_c.func_177952_p() + Math.random(), (Math.random() - 0.5) * (double)velocityMod, Math.random() * (double)velocityMod, (Math.random() - 0.5) * (double)velocityMod);
        }
    }
}

