/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.blocks.runeforging.RunicAnvilBlock;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.events.EventDispatcher;
import com.ma.items.ritual.ItemPractitionersPatch;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import com.ma.items.runes.ItemRune;
import com.ma.items.runes.ItemRunePattern;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.ma.tools.MATags;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class RunicAnvilTile
extends TileEntityWithInventory
implements IForgeTileEntity,
ISidedInventory {
    private static final int MAX_ITEMS = 2;
    public static final int PATTERN_SLOT_INDEX = 0;
    public static final int MATERIAL_SLOT_INDEX = 1;
    public static final int TOOL_SLOT_INDEX = 2;
    public static final int ADVANCE_RESPONSE_ADVANCED = 0;
    public static final int ADVANCE_RESPONSE_NO_MATCH = 1;
    public static final int ADVANCE_RESPONSE_LOW_TIER = 2;
    public static final int ADVANCE_RESPONSE_CLIENT_WORLD = 3;
    public static final int ADVANCE_RESPONSE_CRAFTING_COMPLETE = 4;
    public int craftProgress = 0;
    public int maxCraftProgress = 10;
    private ItemStack __cachedRecipeOutput = ItemStack.field_190927_a;
    private RuneforgingRecipe __cachedRecipe;
    private Optional<ManaweavingRecipe> __cachedEnchantRecipe;
    private boolean autoCacheRecipe = true;
    private boolean settingCraftOutput = false;

    public RunicAnvilTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 2);
    }

    public RunicAnvilTile() {
        this((TileEntityType)TileEntityInit.RUNIC_ANVIL.get());
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub_1 = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub_1);
        base.func_218657_a("invSync_1", (INBT)sub_1);
        CompoundNBT sub_2 = new CompoundNBT();
        this.func_70301_a(1).func_77955_b(sub_2);
        base.func_218657_a("invSync_2", (INBT)sub_2);
        base.func_74768_a("craft_progress", this.craftProgress);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync_1");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
        CompoundNBT sub2 = tag.func_74775_l("invSync_2");
        this.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)sub2));
        this.craftProgress = tag.func_74762_e("craft_progress");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        CompoundNBT sub_1 = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub_1);
        data.func_218657_a("invSync_1", (INBT)sub_1);
        CompoundNBT sub_2 = new CompoundNBT();
        this.func_70301_a(1).func_77955_b(sub_2);
        data.func_218657_a("invSync_2", (INBT)sub_2);
        data.func_74768_a("craft_progress", this.craftProgress);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        CompoundNBT sub = data.func_74775_l("invSync_1");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
        CompoundNBT sub2 = data.func_74775_l("invSync_2");
        this.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)sub2));
        this.craftProgress = data.func_74762_e("craft_progress");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("craft_progress", this.craftProgress);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.craftProgress = compound.func_74762_e("craft_progress");
        super.func_230337_a_(state, compound);
    }

    public int func_70297_j_() {
        return this.settingCraftOutput ? 64 : 1;
    }

    public int getMaxCraftProgress() {
        return this.__cachedRecipe != null ? this.__cachedRecipe.getHits() : this.maxCraftProgress;
    }

    public ItemStack[] getDisplayedItems() {
        return new ItemStack[]{this.func_70301_a(0), this.func_70301_a(1)};
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    public boolean pushItemStack(ItemStack stack, int playerTier) {
        if (stack.func_190916_E() != 1) {
            return false;
        }
        if (this.func_70301_a(0).func_190926_b()) {
            this.func_70299_a(0, stack);
            return true;
        }
        if (this.func_70301_a(1).func_190926_b()) {
            this.setInventorySlotContentsNoCache(1, stack);
            this.cacheRecipe(playerTier);
            return true;
        }
        return false;
    }

    private void setInventorySlotContentsNoCache(int index, ItemStack stack) {
        this.autoCacheRecipe = false;
        this.func_70299_a(index, stack);
        this.autoCacheRecipe = true;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (this.autoCacheRecipe) {
            this.cacheRecipe(5);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return this.func_70304_b(index);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack output = super.func_70304_b(index);
        if (!output.func_190926_b() && this.autoCacheRecipe) {
            this.cacheRecipe(5);
        }
        return output;
    }

    public ItemStack popItemStack() {
        if (this.craftProgress > 0) {
            return ItemStack.field_190927_a;
        }
        this.__cachedRecipeOutput = ItemStack.field_190927_a;
        if (!this.func_70301_a(1).func_190926_b()) {
            return this.func_70304_b(1);
        }
        if (!this.func_70301_a(0).func_190926_b()) {
            return this.func_70304_b(0);
        }
        return ItemStack.field_190927_a;
    }

    private int cacheRecipe(int playerTier) {
        int output = 1;
        if (this.cacheSpecialRecipes(playerTier)) {
            boolean isActive = (Boolean)this.func_195044_w().func_177229_b((Property)RunicAnvilBlock.ACTIVE);
            if (!isActive) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            CraftingInventory inv = this.createDummyCraftingInventory();
            this.__cachedRecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.RUNEFORGING_TYPE, (IInventory)inv, this.field_145850_b).orElse(null);
            this.__cachedRecipeOutput = ItemStack.field_190927_a;
            if (this.__cachedRecipe == null) {
                ItemStack rune = this.func_70301_a(1);
                if (!rune.func_190926_b()) {
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)rune);
                    this.__cachedEnchantRecipe = this.field_145850_b.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == RecipeInit.MANAWEAVING_RECIPE_TYPE && ((ManaweavingRecipe)r).matches(enchantments)).map(r -> (ManaweavingRecipe)r).findFirst();
                    if (this.__cachedEnchantRecipe.isPresent()) {
                        if (this.__cachedEnchantRecipe.get().getTier() > playerTier) {
                            this.__cachedEnchantRecipe = null;
                            this.__cachedRecipeOutput = ItemStack.field_190927_a;
                            output = 2;
                        } else {
                            this.__cachedRecipeOutput = this.func_70301_a(0).func_77946_l();
                            boolean compatible = true;
                            for (Map.Entry e2 : enchantments.entrySet()) {
                                if (((Enchantment)e2.getKey()).func_92089_a(this.__cachedRecipeOutput)) continue;
                                compatible = false;
                                break;
                            }
                            Map existingEnchants = EnchantmentHelper.func_82781_a((ItemStack)this.__cachedRecipeOutput);
                            block1: for (Map.Entry ee : existingEnchants.entrySet()) {
                                for (Map.Entry e3 : enchantments.entrySet()) {
                                    if (!((Enchantment)e3.getKey()).func_92089_a(this.__cachedRecipeOutput)) {
                                        compatible = false;
                                        continue block1;
                                    }
                                    if (e3.getKey() == ee.getKey() && (Integer)e3.getValue() <= (Integer)ee.getValue()) {
                                        compatible = false;
                                        continue block1;
                                    }
                                    if (((Enchantment)e3.getKey()).func_191560_c((Enchantment)ee.getKey()) || e3.getKey() == ee.getKey() && (Integer)e3.getValue() > (Integer)ee.getValue()) continue;
                                    compatible = false;
                                    continue block1;
                                }
                            }
                            if (compatible) {
                                existingEnchants.forEach((e, i) -> {
                                    if (!enchantments.containsKey(e) || (Integer)enchantments.get(e) < i) {
                                        enchantments.put(e, i);
                                    }
                                });
                                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)this.__cachedRecipeOutput);
                                output = 0;
                            } else {
                                output = 1;
                                this.__cachedRecipeOutput = ItemStack.field_190927_a;
                            }
                        }
                    }
                }
            } else if (this.__cachedRecipe.getTier() <= playerTier) {
                this.__cachedRecipeOutput = this.__cachedRecipe.func_77571_b();
                output = 0;
            } else {
                this.__cachedRecipe = null;
                this.__cachedRecipeOutput = ItemStack.field_190927_a;
                output = 2;
            }
            boolean isActive = (Boolean)this.func_195044_w().func_177229_b((Property)RunicAnvilBlock.ACTIVE);
            if (!this.__cachedRecipeOutput.func_190926_b()) {
                if (!isActive) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (isActive) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 0);
            }
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return output;
    }

    private boolean cacheSpecialRecipes(int playerTier) {
        return this.cachePouch() || this.cachePattern();
    }

    private boolean cachePouch() {
        ItemStack pouchStack = this.func_70301_a(0);
        if (!(pouchStack.func_77973_b() instanceof ItemPractitionersPouch)) {
            return false;
        }
        ItemStack patchStack = this.func_70301_a(1);
        if (!(patchStack.func_77973_b() instanceof ItemPractitionersPatch)) {
            return false;
        }
        PractitionersPouchPatches patch = ((ItemPractitionersPatch)patchStack.func_77973_b()).getPatch();
        int patchLevel = ((ItemPractitionersPatch)patchStack.func_77973_b()).getLevel();
        if (((ItemPractitionersPouch)pouchStack.func_77973_b()).getPatchLevel(pouchStack, patch) >= patchLevel) {
            return false;
        }
        return ((ItemPractitionersPouch)pouchStack.func_77973_b()).countAppliedPatchesForLimit(pouchStack) < 3;
    }

    private boolean cachePattern() {
        ItemStack runeStack = this.func_70301_a(0);
        if (!(runeStack.func_77973_b() instanceof ItemRune)) {
            return false;
        }
        ItemStack patchStack = this.func_70301_a(1);
        return patchStack.func_77973_b() == Items.field_151121_aF;
    }

    public int advanceCrafting(PlayerEntity crafter, int playerTier) {
        return this.advanceCrafting(crafter, playerTier, true);
    }

    public int advanceCrafting(PlayerEntity crafter, int playerTier, boolean allowDurability) {
        int cacheResponse = this.cacheRecipe(playerTier);
        if (this.field_145850_b.field_72995_K) {
            return 3;
        }
        if (this.__cachedRecipeOutput.func_190926_b()) {
            this.abortCrafting();
            return cacheResponse;
        }
        ++this.craftProgress;
        int targetProgress = this.getMaxCraftProgress();
        if (this.craftProgress >= targetProgress) {
            this.craftProgress = 0;
            if (this.__cachedRecipe != null) {
                if (!EventDispatcher.DispatchRuneforgeCraft(this.__cachedRecipe, this.__cachedRecipeOutput, crafter)) {
                    this.abortCrafting();
                    return cacheResponse;
                }
            } else if (this.__cachedEnchantRecipe != null && !EventDispatcher.DispatchRuneforgeEnchant(this.__cachedRecipeOutput, crafter)) {
                this.abortCrafting();
                return cacheResponse;
            }
            this.completeCraftingAndReset(allowDurability);
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RunicAnvilBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            return 4;
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        return 0;
    }

    private void abortCrafting() {
        InventoryHelper.func_180175_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IInventory)this);
        this.func_174888_l();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    private void completeCraftingAndReset(boolean allowPatternDurability) {
        this.settingCraftOutput = true;
        ItemStack patternStack = this.func_70301_a(0);
        if (allowPatternDurability && patternStack.func_77973_b() instanceof ItemRunePattern) {
            if (!ItemRunePattern.incrementDamage(patternStack)) {
                this.func_70299_a(1, this.__cachedRecipeOutput);
            } else {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_232764_iu_, SoundCategory.BLOCKS, 1.0f, (float)(0.8 + Math.random() * 0.4));
                this.func_70299_a(0, this.__cachedRecipeOutput);
                this.func_70299_a(1, ItemStack.field_190927_a);
            }
        } else {
            this.func_70299_a(0, this.__cachedRecipeOutput);
            this.func_70299_a(1, ItemStack.field_190927_a);
        }
        this.settingCraftOutput = false;
        this.__cachedRecipeOutput = ItemStack.field_190927_a;
        this.__cachedRecipe = null;
        this.__cachedEnchantRecipe = null;
    }

    public ItemStack getOutputStack() {
        return this.__cachedRecipeOutput;
    }

    @Nullable
    public RuneforgingRecipe getCachedRecipe() {
        return this.__cachedRecipe;
    }

    private CraftingInventory createDummyCraftingInventory() {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, this.func_70301_a(0));
        craftinginventory.func_70299_a(1, this.func_70301_a(1));
        return craftinginventory;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (itemStackIn.func_190916_E() != 1) {
            return false;
        }
        if (index == 1) {
            return !this.func_70301_a(0).func_190926_b() && this.func_70301_a(1).func_190926_b();
        }
        if (index == 0) {
            return this.func_70301_a(1).func_190926_b() && this.func_70301_a(0).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (!ItemStack.func_179545_c((ItemStack)this.func_70301_a(index), (ItemStack)stack)) {
            return false;
        }
        if (index == 0) {
            return this.func_70301_a(1).func_190926_b() && !this.func_70301_a(0).func_190926_b();
        }
        if (index == 1) {
            return !this.func_70301_a(1).func_190926_b();
        }
        return false;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }
}

