/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.tileentities.init.TileEntityInit;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector3d;

public class ParticleEmitterTile
extends TileEntity
implements ITickableTileEntity {
    int AMOUNT = 1;
    int RATE = 1;
    float RADIUS = 1.0f;
    Vector3d OFFSET = Vector3d.field_186680_a;
    Vector3d VELOCITY = Vector3d.field_186680_a;
    int __spawnCount = 0;
    private ArrayList<Runnable> emitterTypes = new ArrayList();
    int emitterIndex = 0;

    public ParticleEmitterTile() {
        super((TileEntityType)TileEntityInit.PARTICLE_EMITTER.get());
        this.emitterTypes.add(this::spawnTestParticles);
        this.emitterTypes.add(this::spawnArcaneParticles);
        this.emitterTypes.add(this::spawnEarthParticles);
        this.emitterTypes.add(this::spawnEnderParticles);
        this.emitterTypes.add(this::spawnAirParticles);
        this.emitterTypes.add(this::spawnWaterParticles);
        this.emitterTypes.add(this::spawnFrostParticles);
        this.emitterTypes.add(this::spawnFireParticles);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K || this.field_145850_b.func_175640_z(this.func_174877_v())) {
            return;
        }
        this.RATE = 1;
        ++this.__spawnCount;
        if (this.__spawnCount >= this.RATE) {
            this.__spawnCount = 0;
            this.emitterTypes.get(this.emitterIndex).run();
        }
    }

    public void incrementEmitterIndex() {
        ++this.emitterIndex;
        this.emitterIndex %= this.emitterTypes.size();
    }

    private void spawnArcaneParticles() {
        this.AMOUNT = 30;
        this.RADIUS = 0.01f;
        this.OFFSET = new Vector3d(0.5, 1.2, 0.5);
        for (int i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)-0.05f + Math.random() * (double)0.1f, Math.random() * 0.05 + 0.05, (double)-0.05f + Math.random() * (double)0.1f);
        }
    }

    private void spawnEarthParticles() {
        int i;
        this.AMOUNT = 1;
        this.RADIUS = 0.5f;
        this.OFFSET = new Vector3d(0.5, 1.5, 0.5);
        this.VELOCITY = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
        for (i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + Math.random() * (double)this.RADIUS, 0.12156862765550613, 0.4431372582912445, 0.12156862765550613);
        }
        for (i = 0; i < this.AMOUNT * 3; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + Math.random() * (double)this.RADIUS, this.VELOCITY.field_72450_a, this.VELOCITY.field_72448_b, this.VELOCITY.field_72449_c);
        }
    }

    private void spawnEnderParticles() {
        this.AMOUNT = 2;
        this.RADIUS = 0.2f;
        this.OFFSET = new Vector3d(0.5, 1.5, 0.5);
        this.VELOCITY = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
        Vector3d offset = new Vector3d(0.5, 0.0, 0.0);
        for (int angle = 0; angle < 360; angle += 30) {
            Vector3d point = offset.func_178785_b((float)((double)angle * Math.PI / 180.0));
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + point.field_72450_a, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + point.field_72449_c, this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p());
        }
    }

    private void spawnAirParticles() {
        this.AMOUNT = 1;
        this.OFFSET = new Vector3d(0.5, 1.5, 0.5);
        this.VELOCITY = new Vector3d(0.0, (double)0.1f, 0.0);
        for (int i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), this.VELOCITY.field_72450_a, this.VELOCITY.field_72448_b, this.VELOCITY.field_72449_c);
        }
    }

    private void spawnWaterParticles() {
        this.AMOUNT = 1;
        this.RADIUS = 0.2f;
        this.OFFSET = new Vector3d(1.5, 1.0, 0.5);
        this.VELOCITY = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
        for (int i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + Math.random() * (double)this.RADIUS, this.VELOCITY.field_72450_a, this.VELOCITY.field_72448_b, this.VELOCITY.field_72449_c);
        }
    }

    private void spawnFrostParticles() {
        this.AMOUNT = 1;
        this.RADIUS = 0.0f;
        this.OFFSET = new Vector3d(0.5, 1.5, 0.5);
        this.VELOCITY = new Vector3d((double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f, (double)-0.01f + Math.random() * (double)0.02f);
        for (int i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + Math.random() * (double)this.RADIUS, this.VELOCITY.field_72450_a, this.VELOCITY.field_72448_b, this.VELOCITY.field_72449_c);
        }
    }

    private void spawnFireParticles() {
        this.AMOUNT = 3;
        this.RADIUS = 0.0f;
        this.OFFSET = new Vector3d(0.5, 1.0, 0.5);
        this.VELOCITY = new Vector3d((double)-0.01f + Math.random() * 0.02, 0.02, (double)-0.01f + Math.random() * 0.02);
        for (int i = 0; i < this.AMOUNT; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o() + Math.random() * (double)this.RADIUS, this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p() + Math.random() * (double)this.RADIUS, this.VELOCITY.field_72450_a, this.VELOCITY.field_72448_b, this.VELOCITY.field_72449_c);
        }
    }

    private void spawnTestParticles() {
        block9: {
            long stageTicks;
            block15: {
                int type;
                float SPEED;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        this.AMOUNT = 360;
                                        this.OFFSET = new Vector3d(0.5, 3.5, 0.5);
                                        SPEED = 0.1f;
                                        type = 5;
                                        if (type != 0) break block8;
                                        this.RADIUS = 1.0f;
                                        for (int i = 0; i < this.AMOUNT; ++i) {
                                            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED, (double)i, (double)this.RADIUS);
                                        }
                                        break block9;
                                    }
                                    if (type != 1) break block10;
                                    this.AMOUNT = 50;
                                    this.RADIUS = 1.0f;
                                    for (int i = 0; i < this.AMOUNT; ++i) {
                                        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED, (double)i, (double)this.RADIUS);
                                    }
                                    break block9;
                                }
                                if (type != 2) break block11;
                                this.AMOUNT = 50;
                                this.RADIUS = 0.5f + (float)(this.field_145850_b.func_82737_E() % 20L) / 20.0f * 0.25f;
                                for (int i = 0; i < this.AMOUNT; ++i) {
                                    this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED + Math.random() * (double)0.3f, (double)this.field_145850_b.func_82737_E() + Math.random() * 20.0, (double)this.RADIUS);
                                }
                                break block9;
                            }
                            if (type != 3) break block12;
                            this.RADIUS = 0.5f + (float)(this.field_145850_b.func_82737_E() % 20L) / 20.0f * 0.25f;
                            for (int i = 0; i < this.AMOUNT; ++i) {
                                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED + Math.random() * (double)0.2f, (double)this.field_145850_b.func_82737_E(), (double)this.RADIUS);
                                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED + Math.random() * (double)0.2f, (double)(this.field_145850_b.func_82737_E() + 120L), (double)this.RADIUS);
                                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED + Math.random() * (double)0.2f, (double)(this.field_145850_b.func_82737_E() + 240L), (double)this.RADIUS);
                            }
                            break block9;
                        }
                        if (type != 4) break block13;
                        this.RADIUS = 1.0f + (float)(this.field_145850_b.func_82737_E() % 100L) / 100.0f;
                        for (int i = 0; i < this.AMOUNT; ++i) {
                            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED, (double)i, (double)this.RADIUS);
                        }
                        break block9;
                    }
                    if (type != 5) break block14;
                    this.RADIUS = 1.0f - (float)(this.field_145850_b.func_82737_E() % 100L) / 100.0f;
                    for (int i = 0; i < this.AMOUNT; ++i) {
                        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED, (double)i, (double)this.RADIUS);
                    }
                    break block9;
                }
                if (type != 6) break block9;
                stageTicks = this.field_145850_b.func_82737_E() % 200L;
                if (stageTicks >= 40L) break block15;
                this.RADIUS = 1.0f - (float)(this.field_145850_b.func_82737_E() % 40L) / 40.0f;
                this.AMOUNT = 100;
                for (int i = 0; i < this.AMOUNT; ++i) {
                    this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), (double)SPEED, Math.random(), (double)this.RADIUS);
                }
                break block9;
            }
            if (stageTicks <= 60L || stageTicks >= 63L) break block9;
            this.RADIUS = 1L + stageTicks;
            for (int i = 0; i < this.AMOUNT; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.OFFSET.field_72450_a + (double)this.func_174877_v().func_177958_n(), this.OFFSET.field_72448_b + (double)this.func_174877_v().func_177956_o(), this.OFFSET.field_72449_c + (double)this.func_174877_v().func_177952_p(), Math.random() - 0.5, (double)0.04f, Math.random() - 0.5);
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        base.func_74768_a("spawn_function_index", this.emitterIndex);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.emitterIndex = tag.func_74762_e("spawn_function_index");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("spawn_function_index", this.emitterIndex);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.emitterIndex = data.func_74762_e("spawn_function_index");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("spawn_function_index", this.emitterIndex);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("spawn_function_index")) {
            this.emitterIndex = compound.func_74762_e("spawn_function_index");
        }
        super.func_230337_a_(state, compound);
    }
}

