/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.tile.IPowerSupplierTile;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.particles.types.movers.ParticleOrbitMover;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class EldrinConduitTile
extends TileEntity
implements ITickableTileEntity,
IPowerSupplierTile {
    private Affinity affinity;

    public EldrinConduitTile(TileEntityType<?> p_i48289_1_, Affinity affinity) {
        super(p_i48289_1_);
        this.affinity = affinity;
    }

    public EldrinConduitTile(TileEntityType<?> p_i48289_1_) {
        this(p_i48289_1_, Affinity.UNKNOWN);
    }

    public EldrinConduitTile(Affinity affinity) {
        this((TileEntityType)TileEntityInit.ELDRIN_CONDUIT_TILE.get(), affinity);
    }

    public EldrinConduitTile() {
        this(Affinity.UNKNOWN);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74778_a("affinity", this.affinity.name());
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_74764_b("affinity")) {
            this.affinity = Affinity.valueOf(nbt.func_74779_i("affinity"));
        }
        super.func_230337_a_(state, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            switch (this.affinity) {
                case FIRE: 
                case HELLFIRE: {
                    this.spawnFireParticles();
                    break;
                }
                case WATER: 
                case ICE: {
                    this.spawnWaterParticles();
                    break;
                }
                case WIND: {
                    this.spawnWindParticles();
                    break;
                }
                case EARTH: {
                    this.spawnEarthParticles();
                    break;
                }
                case ENDER: {
                    this.spawnEnterParticles();
                    break;
                }
                default: {
                    this.spawnArcaneParticles();
                }
            }
            int[] color = this.affinity.getColor();
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setColor(color[0], color[1], color[2]), (double)((float)this.func_174877_v().func_177958_n() + 0.4f) + Math.random() * (double)0.2f, (double)((float)this.func_174877_v().func_177956_o() + 1.4f), (double)((float)this.func_174877_v().func_177952_p() + 0.4f) + Math.random() * (double)0.2f, 0.0, 0.01, 0.0);
            }
        }
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    private void spawnFireParticles() {
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.7f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), 0.0, 0.01, 0.0);
    }

    private void spawnWaterParticles() {
        Vector3d center = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.75f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())).setMaxAge(2).setMover(new ParticleOrbitMover(center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.25, 0.0, 0.05)), center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
    }

    private void spawnWindParticles() {
        Vector3d center = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.55f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setMaxAge(2).setMover(new ParticleOrbitMover(center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.25, 0.01, 0.05)), center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
    }

    private void spawnEarthParticles() {
        Vector3d center = new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.1f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setGravity(0.002f), center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
    }

    private void spawnArcaneParticles() {
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())).setScale(0.1f).setMaxAge(13), (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.75f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), 0.0, 0.0, 0.0);
    }

    private void spawnEnterParticles() {
        BlockPos bp = this.func_174877_v();
        float angle = this.field_145850_b.func_82737_E() % 36L * 10L;
        Vector3d rotationOffset = new Vector3d(0.25, 0.0, 0.0);
        Vector3d point = rotationOffset.func_178785_b((float)((double)angle * Math.PI / 180.0));
        this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (double)((float)bp.func_177958_n() + 0.5f) + point.field_72450_a, (double)((float)bp.func_177956_o() + 0.75f), (double)((float)bp.func_177952_p() + 0.5f) + point.field_72449_c, (double)((float)bp.func_177958_n() + 0.5f), (double)((float)bp.func_177956_o() + 0.75f), (double)((float)bp.func_177952_p() + 0.5f));
    }
}

