/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.init.TileEntityInit;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class CoffinTile
extends TileEntity {
    private Optional<UUID> player = Optional.empty();
    private PlayerEntity cachedPlayer;

    public CoffinTile() {
        super((TileEntityType)TileEntityInit.COFFIN.get());
    }

    public void setRitualPlayer(PlayerEntity player) {
        this.player = player == null ? Optional.empty() : Optional.of(player.func_146103_bH().getId());
        this.cachedPlayer = player;
    }

    public PlayerEntity getRitualPlayer() {
        if (this.cachedPlayer == null && this.player.isPresent()) {
            this.cachedPlayer = this.field_145850_b.func_217371_b(this.player.get());
        }
        return this.cachedPlayer;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.player.isPresent()) {
            compound.func_74778_a("player", this.player.get().toString());
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("player")) {
            try {
                UUID playerId = UUID.fromString(nbt.func_74779_i("player"));
                this.player = Optional.of(playerId);
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.warn("Unable to load player UUID for ritual coffin; it will simply act as a normal coffin.  This shouldn't happen, the save file was likely edited incorrectly.");
            }
        }
    }
}

