/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.tools.MATags;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class ChalkRuneTile
extends TileEntityWithInventory
implements IForgeTileEntity {
    private static final int MAX_ITEMS = 1;
    public static final int INVENTORY_SLOT_INDEX = 0;
    private boolean readOnly = false;
    private boolean ghostItem = false;

    public ChalkRuneTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 1);
    }

    public ChalkRuneTile() {
        this((TileEntityType)TileEntityInit.CHALK_RUNE.get());
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.readOnly || this.ghostItem) {
            return;
        }
        super.func_70299_a(index, stack);
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.readOnly || this.ghostItem) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = super.func_70304_b(index);
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return stack;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack out = super.func_70298_a(index, count);
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        return out;
    }

    public void clearStack() {
        super.func_70304_b(0);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setGhostItem(boolean ghost) {
        this.ghostItem = ghost;
    }

    public boolean isGhostItem() {
        return this.ghostItem;
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(sub);
        base.func_218657_a("invSync", (INBT)sub);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)sub));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.func_70301_a(0).func_77955_b(data);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)data));
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack getDisplayedItem() {
        return this.func_70301_a(0);
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("readOnly")) {
            this.readOnly = compound.func_74767_n("readOnly");
        }
        if (compound.func_74764_b("ghostItem")) {
            this.ghostItem = compound.func_74767_n("ghostItem");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("readOnly", this.readOnly);
        compound.func_74757_a("ghostItem", this.ghostItem);
        return super.func_189515_b(compound);
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_70301_a(0).func_190926_b();
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !this.func_70301_a(0).func_190926_b() && !this.isGhostItem();
    }
}

