/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.google.common.collect.ImmutableMap;
import com.ma.blocks.BlockInit;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.extensions.IForgeBlock;

public class HellfireBlock
extends AbstractFireBlock
implements ICutoutBlock,
IDontCreateBlockItem,
IForgeBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(facingProperty -> facingProperty.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private final Object2IntMap<Block> encouragements = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> flammabilities = new Object2IntOpenHashMap();

    public HellfireBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151581_o).func_226896_b_().func_200942_a().func_200946_b().func_235838_a_(state -> 15).func_200947_a(SoundType.field_185854_g), 3.0f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().filter(p_242674_0_ -> (Integer)p_242674_0_.func_177229_b((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), HellfireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_242673_0_) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)p_242673_0_.func_177229_b((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_242673_0_.func_177229_b((Property)NORTH)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_242673_0_.func_177229_b((Property)SOUTH)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_242673_0_.func_177229_b((Property)EAST)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_242673_0_.func_177229_b((Property)WEST)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.func_197766_b() ? field_235320_b_ : voxelshape;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? this.getFireWithAge(worldIn, currentPos, (Integer)stateIn.func_177229_b((Property)AGE)) : Blocks.field_150350_a.func_176223_P();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapesCache.get(state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    protected BlockState getStateForPlacement(IBlockReader blockReader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = blockReader.func_180495_p(blockpos);
        if (!this.canCatchFire(blockReader, pos, Direction.UP) && !blockstate.func_224755_d(blockReader, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.func_206870_a((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(blockReader, pos.func_177972_a(direction), direction.func_176734_d())));
            }
            return blockstate1;
        }
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)worldIn, pos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, HellfireBlock.getTickCooldown(worldIn.field_73012_v));
        if (worldIn.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            }
            BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
            boolean flag = blockstate.isFireSource((IWorldReader)worldIn, pos, Direction.UP);
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (!flag && worldIn.func_72896_J() && this.canDie((World)worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                worldIn.func_217377_a(pos, false);
            } else {
                boolean flag1;
                int j = Math.min(15, i + rand.nextInt(3) / 2);
                if (i != j) {
                    state = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j));
                    worldIn.func_180501_a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.areNeighborsFlammable((IBlockReader)worldIn, pos)) {
                        BlockPos blockpos = pos.func_177977_b();
                        if (!worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || i > 3) {
                            worldIn.func_217377_a(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP)) {
                        worldIn.func_217377_a(pos, false);
                        return;
                    }
                }
                int k = (flag1 = worldIn.func_180502_D(pos)) ? -50 : 0;
                this.tryCatchFire((World)worldIn, pos.func_177974_f(), 300 + k, rand, i, Direction.WEST);
                this.tryCatchFire((World)worldIn, pos.func_177976_e(), 300 + k, rand, i, Direction.EAST);
                this.tryCatchFire((World)worldIn, pos.func_177977_b(), 250 + k, rand, i, Direction.UP);
                this.tryCatchFire((World)worldIn, pos.func_177984_a(), 250 + k, rand, i, Direction.DOWN);
                this.tryCatchFire((World)worldIn, pos.func_177978_c(), 300 + k, rand, i, Direction.SOUTH);
                this.tryCatchFire((World)worldIn, pos.func_177968_d(), 300 + k, rand, i, Direction.NORTH);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutable.func_239621_a_((Vector3i)pos, l, j1, i1);
                            int l1 = this.getNeighborEncouragement((IWorldReader)worldIn, (BlockPos)blockpos$mutable);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || rand.nextInt(k1) > i2 || worldIn.func_72896_J() && this.canDie((World)worldIn, (BlockPos)blockpos$mutable)) continue;
                            int j2 = Math.min(15, i + rand.nextInt(5) / 4);
                            worldIn.func_180501_a((BlockPos)blockpos$mutable, this.getFireWithAge((IWorld)worldIn, (BlockPos)blockpos$mutable, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean canDie(World worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    public int getFlammability(BlockState state) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? 0 : this.flammabilities.getInt((Object)state.func_177230_c());
    }

    @Deprecated
    public int getFireSpreadSpeed(BlockState state) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? 0 : this.encouragements.getInt((Object)state.func_177230_c()) * 2;
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face) {
        int i = worldIn.func_180495_p(pos).getFlammability((IBlockReader)worldIn, pos, face);
        if (random.nextInt(chance) < i) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5) {
                int j = Math.min(age + random.nextInt(5) / 4, 15);
                worldIn.func_180501_a(pos, this.getFireWithAge((IWorld)worldIn, pos, j), 3);
            } else {
                worldIn.func_217377_a(pos, false);
            }
            blockstate.catchFire(worldIn, pos, face, null);
        }
    }

    private BlockState getFireWithAge(IWorld world, BlockPos pos, int age) {
        return (BlockState)this.getStateForPlacement((IBlockReader)world, pos).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    private boolean areNeighborsFlammable(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean func_196446_i(BlockState state) {
        return this.getFireSpreadSpeed(state) > 0;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, HellfireBlock.getTickCooldown(worldIn.field_73012_v));
    }

    private static int getTickCooldown(Random rand) {
        return 5 + rand.nextInt(10);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    private void setFireInfo(Block blockIn, int encouragement, int flammability) {
        if (blockIn == Blocks.field_150350_a) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.encouragements.put((Object)blockIn, encouragement);
        this.flammabilities.put((Object)blockIn, flammability);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }

    public static void init() {
        HellfireBlock fireblock = (HellfireBlock)BlockInit.HELLFIRE.get();
        fireblock.setFireInfo(Blocks.field_196662_n, 5, 20);
        fireblock.setFireInfo(Blocks.field_196664_o, 5, 20);
        fireblock.setFireInfo(Blocks.field_196666_p, 5, 20);
        fireblock.setFireInfo(Blocks.field_196668_q, 5, 20);
        fireblock.setFireInfo(Blocks.field_196670_r, 5, 20);
        fireblock.setFireInfo(Blocks.field_196672_s, 5, 20);
        fireblock.setFireInfo(Blocks.field_196622_bq, 5, 20);
        fireblock.setFireInfo(Blocks.field_196624_br, 5, 20);
        fireblock.setFireInfo(Blocks.field_196627_bs, 5, 20);
        fireblock.setFireInfo(Blocks.field_196630_bt, 5, 20);
        fireblock.setFireInfo(Blocks.field_196632_bu, 5, 20);
        fireblock.setFireInfo(Blocks.field_196635_bv, 5, 20);
        fireblock.setFireInfo(Blocks.field_180390_bo, 5, 20);
        fireblock.setFireInfo(Blocks.field_180391_bp, 5, 20);
        fireblock.setFireInfo(Blocks.field_180392_bq, 5, 20);
        fireblock.setFireInfo(Blocks.field_180386_br, 5, 20);
        fireblock.setFireInfo(Blocks.field_180385_bs, 5, 20);
        fireblock.setFireInfo(Blocks.field_180387_bt, 5, 20);
        fireblock.setFireInfo(Blocks.field_180407_aO, 5, 20);
        fireblock.setFireInfo(Blocks.field_180408_aP, 5, 20);
        fireblock.setFireInfo(Blocks.field_180404_aQ, 5, 20);
        fireblock.setFireInfo(Blocks.field_180403_aR, 5, 20);
        fireblock.setFireInfo(Blocks.field_180406_aS, 5, 20);
        fireblock.setFireInfo(Blocks.field_180405_aT, 5, 20);
        fireblock.setFireInfo(Blocks.field_150476_ad, 5, 20);
        fireblock.setFireInfo(Blocks.field_150487_bG, 5, 20);
        fireblock.setFireInfo(Blocks.field_150485_bF, 5, 20);
        fireblock.setFireInfo(Blocks.field_150481_bH, 5, 20);
        fireblock.setFireInfo(Blocks.field_150400_ck, 5, 20);
        fireblock.setFireInfo(Blocks.field_150401_cl, 5, 20);
        fireblock.setFireInfo(Blocks.field_196617_K, 5, 5);
        fireblock.setFireInfo(Blocks.field_196618_L, 5, 5);
        fireblock.setFireInfo(Blocks.field_196619_M, 5, 5);
        fireblock.setFireInfo(Blocks.field_196620_N, 5, 5);
        fireblock.setFireInfo(Blocks.field_196621_O, 5, 5);
        fireblock.setFireInfo(Blocks.field_196623_P, 5, 5);
        fireblock.setFireInfo(Blocks.field_203204_R, 5, 5);
        fireblock.setFireInfo(Blocks.field_203205_S, 5, 5);
        fireblock.setFireInfo(Blocks.field_203206_T, 5, 5);
        fireblock.setFireInfo(Blocks.field_203207_U, 5, 5);
        fireblock.setFireInfo(Blocks.field_203208_V, 5, 5);
        fireblock.setFireInfo(Blocks.field_203209_W, 5, 5);
        fireblock.setFireInfo(Blocks.field_209389_ab, 5, 5);
        fireblock.setFireInfo(Blocks.field_209390_ac, 5, 5);
        fireblock.setFireInfo(Blocks.field_209391_ad, 5, 5);
        fireblock.setFireInfo(Blocks.field_209392_ae, 5, 5);
        fireblock.setFireInfo(Blocks.field_209393_af, 5, 5);
        fireblock.setFireInfo(Blocks.field_209394_ag, 5, 5);
        fireblock.setFireInfo(Blocks.field_196626_Q, 5, 5);
        fireblock.setFireInfo(Blocks.field_196629_R, 5, 5);
        fireblock.setFireInfo(Blocks.field_196631_S, 5, 5);
        fireblock.setFireInfo(Blocks.field_196634_T, 5, 5);
        fireblock.setFireInfo(Blocks.field_196637_U, 5, 5);
        fireblock.setFireInfo(Blocks.field_196639_V, 5, 5);
        fireblock.setFireInfo(Blocks.field_196642_W, 30, 60);
        fireblock.setFireInfo(Blocks.field_196645_X, 30, 60);
        fireblock.setFireInfo(Blocks.field_196647_Y, 30, 60);
        fireblock.setFireInfo(Blocks.field_196648_Z, 30, 60);
        fireblock.setFireInfo(Blocks.field_196572_aa, 30, 60);
        fireblock.setFireInfo(Blocks.field_196574_ab, 30, 60);
        fireblock.setFireInfo(Blocks.field_150342_X, 30, 20);
        fireblock.setFireInfo(Blocks.field_150335_W, 15, 100);
        fireblock.setFireInfo(Blocks.field_150349_c, 60, 100);
        fireblock.setFireInfo(Blocks.field_196554_aH, 60, 100);
        fireblock.setFireInfo(Blocks.field_196555_aI, 60, 100);
        fireblock.setFireInfo(Blocks.field_196800_gd, 60, 100);
        fireblock.setFireInfo(Blocks.field_196801_ge, 60, 100);
        fireblock.setFireInfo(Blocks.field_196802_gf, 60, 100);
        fireblock.setFireInfo(Blocks.field_196803_gg, 60, 100);
        fireblock.setFireInfo(Blocks.field_196804_gh, 60, 100);
        fireblock.setFireInfo(Blocks.field_196805_gi, 60, 100);
        fireblock.setFireInfo(Blocks.field_196605_bc, 60, 100);
        fireblock.setFireInfo(Blocks.field_196606_bd, 60, 100);
        fireblock.setFireInfo(Blocks.field_196607_be, 60, 100);
        fireblock.setFireInfo(Blocks.field_196609_bf, 60, 100);
        fireblock.setFireInfo(Blocks.field_196610_bg, 60, 100);
        fireblock.setFireInfo(Blocks.field_196612_bh, 60, 100);
        fireblock.setFireInfo(Blocks.field_196613_bi, 60, 100);
        fireblock.setFireInfo(Blocks.field_196614_bj, 60, 100);
        fireblock.setFireInfo(Blocks.field_196615_bk, 60, 100);
        fireblock.setFireInfo(Blocks.field_196616_bl, 60, 100);
        fireblock.setFireInfo(Blocks.field_222387_by, 60, 100);
        fireblock.setFireInfo(Blocks.field_222383_bA, 60, 100);
        fireblock.setFireInfo(Blocks.field_222388_bz, 60, 100);
        fireblock.setFireInfo(Blocks.field_196556_aL, 30, 60);
        fireblock.setFireInfo(Blocks.field_196557_aM, 30, 60);
        fireblock.setFireInfo(Blocks.field_196558_aN, 30, 60);
        fireblock.setFireInfo(Blocks.field_196559_aO, 30, 60);
        fireblock.setFireInfo(Blocks.field_196560_aP, 30, 60);
        fireblock.setFireInfo(Blocks.field_196561_aQ, 30, 60);
        fireblock.setFireInfo(Blocks.field_196562_aR, 30, 60);
        fireblock.setFireInfo(Blocks.field_196563_aS, 30, 60);
        fireblock.setFireInfo(Blocks.field_196564_aT, 30, 60);
        fireblock.setFireInfo(Blocks.field_196565_aU, 30, 60);
        fireblock.setFireInfo(Blocks.field_196566_aV, 30, 60);
        fireblock.setFireInfo(Blocks.field_196567_aW, 30, 60);
        fireblock.setFireInfo(Blocks.field_196568_aX, 30, 60);
        fireblock.setFireInfo(Blocks.field_196569_aY, 30, 60);
        fireblock.setFireInfo(Blocks.field_196570_aZ, 30, 60);
        fireblock.setFireInfo(Blocks.field_196602_ba, 30, 60);
        fireblock.setFireInfo(Blocks.field_150395_bd, 15, 100);
        fireblock.setFireInfo(Blocks.field_150402_ci, 5, 5);
        fireblock.setFireInfo(Blocks.field_150407_cf, 60, 20);
        fireblock.setFireInfo(Blocks.field_235396_nb_, 15, 20);
        fireblock.setFireInfo(Blocks.field_196724_fH, 60, 20);
        fireblock.setFireInfo(Blocks.field_196725_fI, 60, 20);
        fireblock.setFireInfo(Blocks.field_196727_fJ, 60, 20);
        fireblock.setFireInfo(Blocks.field_196729_fK, 60, 20);
        fireblock.setFireInfo(Blocks.field_196731_fL, 60, 20);
        fireblock.setFireInfo(Blocks.field_196733_fM, 60, 20);
        fireblock.setFireInfo(Blocks.field_196735_fN, 60, 20);
        fireblock.setFireInfo(Blocks.field_196737_fO, 60, 20);
        fireblock.setFireInfo(Blocks.field_196739_fP, 60, 20);
        fireblock.setFireInfo(Blocks.field_196741_fQ, 60, 20);
        fireblock.setFireInfo(Blocks.field_196743_fR, 60, 20);
        fireblock.setFireInfo(Blocks.field_196745_fS, 60, 20);
        fireblock.setFireInfo(Blocks.field_196747_fT, 60, 20);
        fireblock.setFireInfo(Blocks.field_196749_fU, 60, 20);
        fireblock.setFireInfo(Blocks.field_196751_fV, 60, 20);
        fireblock.setFireInfo(Blocks.field_196753_fW, 60, 20);
        fireblock.setFireInfo(Blocks.field_203216_jz, 30, 60);
        fireblock.setFireInfo(Blocks.field_222405_kQ, 60, 60);
        fireblock.setFireInfo(Blocks.field_222420_lI, 60, 60);
        fireblock.setFireInfo(Blocks.field_222428_lQ, 30, 20);
        fireblock.setFireInfo(Blocks.field_222436_lZ, 5, 20);
        fireblock.setFireInfo(Blocks.field_222434_lW, 60, 100);
        fireblock.setFireInfo(Blocks.field_226906_mb_, 5, 20);
        fireblock.setFireInfo(Blocks.field_226905_ma_, 30, 20);
    }
}

