/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.runeforging;

import com.ma.api.items.MAItemGroups;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.tileentities.PedestalTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.tools.MATags;
import com.ma.tools.RLoc;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PedestalBlock
extends WaterloggableBlock
implements ICutoutBlock,
ICustomCategory {
    private static final ResourceLocation DIM_LIGHT_ITEMS = RLoc.create("pedestal_dim_light_items");
    private static final ResourceLocation BRIGHT_LIGHT_ITEMS = RLoc.create("pedestal_bright_light_items");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final BooleanProperty SHOW_SIGN = BooleanProperty.func_177716_a((String)"show_sign");
    private final boolean showSign;

    public PedestalBlock(boolean withSign) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200943_b(3.0f).func_226896_b_().func_200947_a(SoundType.field_185851_d), false);
        this.showSign = withSign;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)SHOW_SIGN, (Comparable)Boolean.valueOf(this.showSign)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HorizontalBlock.field_185512_D, SHOW_SIGN});
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.PEDESTAL.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack activeStack = player.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof PedestalTile) {
            PedestalTile te = (PedestalTile)tileEntity;
            if (!te.func_191420_l()) {
                ItemStack stack = te.func_70298_a(0, 1);
                if (!player.func_191521_c(stack)) {
                    player.func_71019_a(stack, true);
                }
            } else if (!activeStack.func_190926_b() && te.func_191420_l()) {
                ItemStack single = activeStack.func_77946_l();
                single.func_190920_e(1);
                te.func_70299_a(0, single);
                if (!player.func_184812_l_()) {
                    activeStack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.CONSUME;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        PedestalTile pt;
        ItemStack displayed;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof PedestalTile && !(displayed = (pt = (PedestalTile)te).getDisplayedItem()).func_190926_b()) {
            if (MATags.isItemIn(displayed.func_77973_b(), BRIGHT_LIGHT_ITEMS)) {
                return 15;
            }
            if (MATags.isItemIn(displayed.func_77973_b(), DIM_LIGHT_ITEMS)) {
                return 10;
            }
        }
        return super.getLightValue(state, world, pos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropInventory(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof PedestalTile) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof PedestalTile) {
            return Container.func_94526_b((IInventory)((PedestalTile)te));
        }
        return 0;
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.runes;
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return VoxelShapes.func_197880_a();
    }
}

