/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.ritual;

import com.ma.api.blocks.ISpellInteractibleBlock;
import com.ma.api.items.MAItemGroups;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.entities.sorcery.EntityAffinityIcon;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChimeriteCrystalBlock
extends WaterloggableBlock
implements ISpellInteractibleBlock<ChimeriteCrystalBlock>,
ICustomCategory,
ITranslucentBlock {
    public static final IntegerProperty SURFACE_TYPE = IntegerProperty.func_177719_a((String)"surface", (int)1, (int)3);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public ChimeriteCrystalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_200943_b(2.0f), false);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SURFACE_TYPE, FACING});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face;
        int surfaceType;
        if (context.func_196000_l() == Direction.UP) {
            surfaceType = 1;
            face = context.func_195992_f().func_176734_d();
        } else if (context.func_196000_l() == Direction.DOWN) {
            surfaceType = 2;
            face = context.func_195992_f().func_176734_d();
        } else {
            surfaceType = 3;
            face = context.func_196000_l();
        }
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)face)).func_206870_a((Property)SURFACE_TYPE, (Comparable)Integer.valueOf(surfaceType));
    }

    @Override
    public boolean onHitBySpell(World world, BlockPos pos, ISpellDefinition spell) {
        if (!world.field_72995_K) {
            Vector3d entityPos = this.getPositionBasedOnState(world, pos);
            BlockPos search = new BlockPos(entityPos);
            world.func_217357_a(EntityAffinityIcon.class, new AxisAlignedBB(search)).stream().forEach(e -> e.func_70106_y());
            EntityAffinityIcon efi = new EntityAffinityIcon(world);
            efi.setAffinity(spell.getHighestAffinity());
            efi.func_70107_b(entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c);
            world.func_217376_c((Entity)efi);
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        this.removeEntities(worldIn, pos);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        this.removeEntities(world, pos);
    }

    private void removeEntities(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            Vector3d entityPos = this.getPositionBasedOnState(world, pos);
            BlockPos search = new BlockPos(entityPos);
            world.func_217357_a(EntityAffinityIcon.class, new AxisAlignedBB(search)).stream().forEach(e -> e.func_70106_y());
        }
    }

    private Vector3d getPositionBasedOnState(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Vector3d basePos = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        if (state.func_235901_b_((Property)SURFACE_TYPE) && state.func_235901_b_((Property)FACING)) {
            int surfType = (Integer)state.func_177229_b((Property)SURFACE_TYPE);
            if (surfType == 1) {
                return basePos.func_72441_c(0.0, 1.0, 0.0);
            }
            if (surfType == 2) {
                return basePos.func_72441_c(0.0, -1.0, 0.0);
            }
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            return basePos.func_72441_c((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        }
        return basePos;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 15;
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.constructs;
    }
}

