/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.manaweaving;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.tileentities.ManaweavingAltarTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.items.manaweaving.ItemManaweaverWand;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ManaweavingAltarBlock
extends WaterloggableBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public ManaweavingAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestLevel(3).harvestTool(ToolType.PICKAXE).func_226896_b_(), false);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack activeStack = player.func_184614_ca();
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return ActionResultType.FAIL;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof ManaweavingAltarTile) {
            ManaweavingAltarTile te = (ManaweavingAltarTile)tileEntity;
            if (activeStack.func_190926_b() && te.reCraft(player)) {
                return ActionResultType.SUCCESS;
            }
            if (activeStack.func_77973_b() instanceof ItemManaweaverWand) {
                te.popPattern(player);
            } else if (player.func_213453_ef() || activeStack.func_190926_b()) {
                ItemStack stack = te.popItem(player);
                if (!stack.func_190926_b() && !player.func_191521_c(stack)) {
                    player.func_71019_a(stack, true);
                }
            } else if (!activeStack.func_190926_b()) {
                ItemStack single = activeStack.func_77946_l();
                single.func_190920_e(1);
                if (te.pushItem(player, single) && !player.func_184812_l_()) {
                    activeStack.func_190918_g(1);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.MANAWEAVING_ALTAR.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropInventory(worldIn, pos);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof ManaweavingAltarTile) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
    }
}

