/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.manaweaving;

import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.tileentities.ManaweaveProjectorTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.items.ItemInit;
import com.ma.items.manaweaving.ItemManaweavingPattern;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ManaweaveProjectorBlock
extends WaterloggableBlock
implements ICutoutBlock {
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.func_177719_a((String)"fill_level", (int)0, (int)4);
    public static final BooleanProperty PROJECTING = BooleanProperty.func_177716_a((String)"projecting");
    public static final int EMPTY = 0;
    public static final int QUARTER = 1;
    public static final int HALF = 2;
    public static final int THREE_QUARTERS = 3;
    public static final int FULL = 4;

    public ManaweaveProjectorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestLevel(3).harvestTool(ToolType.PICKAXE).func_226896_b_(), false);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROJECTING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FILL_LEVEL, PROJECTING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.MANAWEAVE_PROJECTOR.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = player.func_184586_b(handIn);
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof ManaweaveProjectorTile) {
                if (stack.func_77973_b() == ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get()) {
                    ResourceLocation rLoc = ((ItemManaweavingPattern)ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get()).getRecipe(stack, worldIn);
                    ((ManaweaveProjectorTile)te).setPattern(rLoc, player);
                    worldIn.func_184138_a(pos, state, state, 2);
                } else {
                    ((ManaweaveProjectorTile)te).trySpawnManaweaveEntity(player);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof ManaweaveProjectorTile) {
            float pct = ((ManaweaveProjectorTile)te).getMana() / 100.0f;
            return (int)(pct * 15.0f);
        }
        return 0;
    }
}

