/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.api.capabilities.Faction;
import com.ma.api.sound.SFX;
import com.ma.blocks.tileentities.CoffinTile;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.rituals.EntityLich;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CoffinBlock
extends BedBlock {
    public CoffinBlock() {
        super(DyeColor.BLACK, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_200943_b(3.0f));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b((Property)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_177230_c() != this) {
            return ActionResultType.CONSUME;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof CoffinTile) {
            CoffinTile coffin = (CoffinTile)te;
            if (coffin.getRitualPlayer() == player) {
                if (!((Boolean)state.func_177229_b((Property)field_176471_b)).booleanValue()) {
                    this.applyColdDark(player, worldIn, state, pos);
                    coffin.setRitualPlayer(null);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
            MutableBoolean canUse = new MutableBoolean(false);
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> canUse.setValue(p.getAlliedFaction() == Faction.UNDEAD));
            if (!canUse.booleanValue()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.faction.cant_use_generic"), Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        return ActionResultType.FAIL;
    }

    private void applyColdDark(PlayerEntity player, World world, BlockState coffin, BlockPos pos) {
        player.getPersistentData().func_74772_a("coldDarkPos", pos.func_218275_a());
        player.func_195064_c(new EffectInstance((Effect)EffectInit.COLD_DARK.get(), 200));
        Direction dir = coffin.getBedDirection((IWorldReader)world, pos).func_176734_d();
        BlockPos destBP = pos.func_177972_a(dir.func_176735_f()).func_177967_a(dir, 2);
        BlockPos startBP = destBP.func_177967_a(dir, 10);
        Vector3d adjustment = Vector3d.field_186680_a;
        switch (dir) {
            case WEST: {
                adjustment = new Vector3d(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                adjustment = new Vector3d(0.0, 0.0, 1.0);
                break;
            }
            case NORTH: {
                adjustment = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                adjustment = new Vector3d(-1.0, 0.0, 0.0);
                break;
            }
        }
        Vector3d dest = new Vector3d((double)((float)destBP.func_177958_n() + 0.5f), (double)destBP.func_177956_o() - 0.5, (double)((float)destBP.func_177952_p() + 0.5f)).func_178787_e(adjustment);
        Vector3d start = new Vector3d((double)startBP.func_177958_n(), (double)startBP.func_177956_o(), (double)startBP.func_177952_p()).func_178787_e(adjustment);
        EntityLich lich = new EntityLich(world);
        lich.setPlayer(player);
        lich.setLerpData(start, dest, 100);
        lich.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        world.func_217376_c((Entity)lich);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SFX.Event.Ritual.COLD_DARK, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 2.0f);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CoffinTile();
    }
}

