/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.targeting;

import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public final class SpellContext {
    private ServerWorld world;
    private Entity targetEntity;
    private ISpellDefinition recipe;
    private HashMap<Component, ArrayList<Entity>> affectedEntities;
    private HashMap<Component, ArrayList<BlockPos>> affectedBlocks;
    private CompoundNBT meta;

    public SpellContext(ServerWorld world, ISpellDefinition recipe) {
        this(world, recipe, null);
    }

    public SpellContext(ServerWorld world, ISpellDefinition recipe, Entity targetEntity) {
        this.world = world;
        this.recipe = recipe;
        this.targetEntity = targetEntity;
        this.affectedEntities = new HashMap();
        this.affectedBlocks = new HashMap();
    }

    public boolean isClientSide() {
        return this.world.field_72995_K;
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public ISpellDefinition getSpell() {
        return this.recipe;
    }

    @Nullable
    public Entity getSpawnedTargetEntity() {
        return this.targetEntity;
    }

    public final void addAffectedEntity(Component component, Entity entity) {
        if (!this.affectedEntities.containsKey(component)) {
            this.affectedEntities.put(component, new ArrayList());
        }
        this.affectedEntities.get(component).add(entity);
    }

    public final boolean hasEntityBeenAffected(Component component, Entity entity) {
        if (!this.affectedEntities.containsKey(component)) {
            return false;
        }
        return this.affectedEntities.get(component).contains(entity);
    }

    public final int countAffectedEntities(Component component) {
        if (!this.affectedEntities.containsKey(component)) {
            return 0;
        }
        return this.affectedEntities.get(component).size();
    }

    public final void addAffectedBlock(Component component, BlockPos pos) {
        if (!this.affectedBlocks.containsKey(component)) {
            this.affectedBlocks.put(component, new ArrayList());
        }
        this.affectedBlocks.get(component).add(pos);
    }

    public final boolean hasBlockBeenAffected(Component component, BlockPos pos) {
        if (!this.affectedBlocks.containsKey(component)) {
            return false;
        }
        return this.affectedBlocks.get(component).contains(pos);
    }

    public final int countAffectedBlocks(Component component) {
        if (!this.affectedBlocks.containsKey(component)) {
            return 0;
        }
        return this.affectedBlocks.get(component).size();
    }

    public final CompoundNBT getMeta() {
        if (this.meta == null) {
            this.meta = new CompoundNBT();
        }
        return this.meta;
    }
}

