/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.attributes;

import com.google.common.collect.ImmutableList;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.config.SpellModConfig;

public final class AttributeValuePair {
    private final Attribute attribute;
    private float value;
    private float min;
    private float max;
    private float step;
    private float stepComplexity;
    private float defaultValue;
    private float multiplier = 1.0f;

    public AttributeValuePair(Attribute attribute, float defaultValue, float min, float max, float step) {
        this(attribute, defaultValue, min, max, step, 1.0f);
    }

    public AttributeValuePair(Attribute attribute, float defaultValue, float min, float max, float step, float stepComplexity) {
        this.attribute = attribute;
        this.value = defaultValue;
        this.min = min;
        this.max = max;
        this.step = step;
        this.defaultValue = defaultValue;
        this.stepComplexity = stepComplexity;
    }

    public void lookupConfig(ISpellComponent instance) {
        this.min = SpellModConfig.getConfiguredValue(instance, this.attribute, SpellModConfig.Value.MINIMUM, this.min);
        this.max = SpellModConfig.getConfiguredValue(instance, this.attribute, SpellModConfig.Value.MAXIMUM, this.max);
        this.step = SpellModConfig.getConfiguredValue(instance, this.attribute, SpellModConfig.Value.STEP, this.step);
        this.defaultValue = SpellModConfig.getConfiguredValue(instance, this.attribute, SpellModConfig.Value.DEFAULT, this.defaultValue);
        this.stepComplexity = SpellModConfig.getConfiguredValue(instance, this.attribute, SpellModConfig.Value.COMPLEXITY, this.stepComplexity);
    }

    public final Attribute getAttribute() {
        return this.attribute;
    }

    public final float getValue() {
        return this.value * this.multiplier;
    }

    public final float getMultiplier() {
        return this.multiplier;
    }

    public final float getDefaultValue() {
        return this.defaultValue;
    }

    public final float getMaximum() {
        return this.max;
    }

    public final float getMinimum() {
        return this.min;
    }

    public final float getStepComplexity() {
        return this.stepComplexity;
    }

    public final void setValue(float value) {
        this.value = value;
    }

    public final void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public final float getStep() {
        return this.step;
    }

    public final float stepUp() {
        this.value += this.step;
        if (this.value > this.max) {
            this.value = this.max;
        }
        return this.value;
    }

    public final float stepDown() {
        this.value -= this.step;
        if (this.value < this.min) {
            this.value = this.min;
        }
        return this.value;
    }

    public AttributeValuePair deepCopy() {
        return new AttributeValuePair(this.attribute, this.defaultValue, this.min, this.max, this.step, this.stepComplexity);
    }

    public static ImmutableList<AttributeValuePair> deepCopy(ImmutableList<AttributeValuePair> source) {
        Object[] values = new AttributeValuePair[source.size()];
        int index = 0;
        for (AttributeValuePair pair : source) {
            values[index++] = pair.deepCopy();
        }
        return ImmutableList.copyOf((Object[])values);
    }
}

