/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.items;

import com.ma.api.recipes.IMARecipe;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public interface ITieredItem<T extends Item> {
    public static final int TIER_NOT_CHECKED = -1;
    public static final int TIER_NO_RECIPE = -2;
    public static final String TAG_HIDE_TIER_IN_TOOLTIP = "hideTier";

    public void setCachedTier(int var1);

    public int getCachedtier();

    default public int getTier(World world, ItemStack stack) {
        if (EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0) {
            return this.resolveTier(world, stack);
        }
        if (this.getCachedtier() == -1) {
            this.setCachedTier(this.resolveTier(world, stack));
        }
        return this.getCachedtier();
    }

    default public int resolveTier(World world, ItemStack stack) {
        List recipes = world.func_199532_z().func_199510_b().stream().filter(r -> r.func_77571_b().func_77973_b() == this).collect(Collectors.toList());
        if (recipes.size() == 0) {
            return -2;
        }
        Map itemEnchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (itemEnchantments.size() == 1) {
            recipes = recipes.stream().filter(r -> {
                Map enchs = EnchantmentHelper.func_82781_a((ItemStack)r.func_77571_b());
                if (enchs.size() != 1) {
                    return false;
                }
                MutableBoolean match = new MutableBoolean(false);
                itemEnchantments.entrySet().forEach(e -> enchs.entrySet().forEach(e2 -> {
                    if (e.getKey() == e2.getKey() && e.getValue() == e2.getValue()) {
                        match.setTrue();
                    }
                }));
                return match.getValue();
            }).collect(Collectors.toList());
        }
        MutableInt lowest = new MutableInt(-2);
        recipes.stream().sorted((a, b) -> {
            if (a instanceof IMARecipe && b instanceof IMARecipe) {
                return ((IMARecipe)a).getTier() < ((IMARecipe)b).getTier() ? -1 : (((IMARecipe)a).getTier() > ((IMARecipe)b).getTier() ? 1 : 0);
            }
            return -1;
        }).findFirst().ifPresent(r -> {
            if (r instanceof IMARecipe) {
                lowest.setValue(((IMARecipe)r).getTier());
            } else {
                lowest.setValue(0);
            }
        });
        return lowest.getValue();
    }
}

