/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;

public class ScreenTextHelper
implements ITextRenderHelper {
    private boolean large = false;
    private TextAlign align = TextAlign.ALIGN_LEFT;
    private boolean dirty = true;
    private int textx;
    private String text;
    private boolean truetype = false;
    private ResourceLocation fontId;
    private static Map<ResourceLocation, FontRenderer> trueTypeRenderer = new HashMap<ResourceLocation, FontRenderer>();

    public int getTextx() {
        return this.textx;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public ITextRenderHelper large(boolean large) {
        this.dirty = true;
        this.large = large;
        return this;
    }

    @Override
    public TextAlign getAlign() {
        return this.align;
    }

    @Override
    public ITextRenderHelper align(TextAlign align) {
        this.dirty = true;
        this.align = align;
        return this;
    }

    @Override
    public void setup(String line, int width, ModuleRenderInfo renderInfo) {
        if (!this.dirty && this.truetype == renderInfo.truetype) {
            return;
        }
        this.dirty = false;
        this.truetype = renderInfo.truetype;
        this.fontId = renderInfo.fontId;
        FontRenderer renderer = ScreenTextHelper.getFontRenderer(this.truetype, this.fontId);
        int n = this.textx = this.large ? 4 : 7;
        if (this.truetype) {
            width *= 2;
        }
        this.text = renderer.func_238412_a_(line, (this.large ? width / 8 : width / 4) - this.textx);
        int w = this.large ? (int)((float)width / 8.8f) : (int)((float)width / 4.45f);
        switch (this.align) {
            case ALIGN_LEFT: {
                break;
            }
            case ALIGN_CENTER: {
                this.textx += (w - renderer.func_78256_a(this.text)) / 2;
                break;
            }
            case ALIGN_RIGHT: {
                this.textx += w - renderer.func_78256_a(this.text);
            }
        }
    }

    @Override
    public void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y, int color, ModuleRenderInfo renderInfo) {
        ScreenTextHelper.renderScaled(this.fontId, matrixStack, buffer, this.text, this.textx + x, y, color, this.truetype, renderInfo.getLightmapValue());
    }

    public static void renderScaled(ResourceLocation fontId, MatrixStack matrixStack, IRenderTypeBuffer buffer, String text, int x, int y, int color, boolean truetype, int lightmapValue) {
        FontRenderer renderer = ScreenTextHelper.getFontRenderer(truetype, fontId);
        if (truetype) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            renderer.func_228079_a_(text, (float)(x * 2), (float)(y * 2), 0xFF000000 | color, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, lightmapValue);
            matrixStack.func_227865_b_();
        } else {
            renderer.func_228079_a_(text, (float)x, (float)y, 0xFF000000 | color, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, lightmapValue);
        }
    }

    public static void renderScaledTrimmed(ResourceLocation fontId, MatrixStack matrixStack, IRenderTypeBuffer buffer, String text, int x, int y, int maxwidth, int color, boolean truetype, int lightmapValue) {
        FontRenderer renderer = ScreenTextHelper.getFontRenderer(truetype, fontId);
        if (truetype) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            text = renderer.func_238412_a_(text, maxwidth * 2);
            renderer.func_228079_a_(text, (float)(x * 2), (float)(y * 2), color, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, lightmapValue);
            matrixStack.func_227865_b_();
        } else {
            text = renderer.func_238412_a_(text, maxwidth);
            renderer.func_228079_a_(text, (float)(x * 2), (float)(y * 2), color, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, lightmapValue);
        }
    }

    private static FontRenderer getFontRenderer(boolean truetype, ResourceLocation fontId) {
        if (truetype) {
            if (!trueTypeRenderer.containsKey(fontId)) {
                Font font = (Font)Minecraft.func_71410_x().field_211501_aD.field_238546_d_.get(fontId);
                trueTypeRenderer.put(fontId, new FontRenderer(resourceLocation -> font));
            }
            return trueTypeRenderer.get(fontId);
        }
        return Minecraft.func_71410_x().field_71466_p;
    }
}

