/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.items;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.various.IItemCycler;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.modules.tablet.TabletModule;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItemHandler;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class TabletItem
extends Item
implements IItemCycler,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/tablet");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public TabletItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(RFToolsBase.setup.getTab()));
    }

    public static int getCurrentSlot(ItemStack stack) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> tag.func_74762_e("Current")).orElse(0);
    }

    public static void setCurrentSlot(PlayerEntity player, ItemStack stack, int current) {
        stack.func_196082_o().func_74768_a("Current", current);
        ItemStack containingItem = TabletItem.getContainingItem(stack, current);
        ItemStack newTablet = TabletItem.deriveNewItemstack(current, containingItem, stack, current);
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)newTablet);
    }

    public static Hand getHand(PlayerEntity player) {
        return player.func_184600_cs() == null ? Hand.MAIN_HAND : player.func_184600_cs();
    }

    public Collection<ItemGroup> getCreativeTabs() {
        if (this == TabletModule.TABLET.get()) {
            return super.getCreativeTabs();
        }
        return Collections.emptyList();
    }

    @Override
    public void cycle(PlayerEntity player, ItemStack stack, boolean next) {
        int currentItem = TabletItem.getCurrentSlot(stack);
        for (int tries = 7; tries > 0; --tries) {
            currentItem = next ? (currentItem + 1) % 6 : (currentItem + 6 - 1) % 6;
            ItemStack containingItem = TabletItem.getContainingItem(stack, currentItem);
            if (containingItem.func_190926_b()) continue;
            TabletItem.setCurrentSlot(player, stack, currentItem);
            player.func_146105_b((ITextComponent)new StringTextComponent("Switched item"), false);
            return;
        }
    }

    public static ItemStack getContainingItem(ItemStack stack, int slot) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item" + slot))).orElse(ItemStack.field_190927_a);
    }

    public static void setContainingItem(PlayerEntity player, Hand hand, int slot, ItemStack containingItem) {
        ItemStack stack = player.func_184586_b(hand);
        CompoundNBT tag = stack.func_196082_o();
        if (containingItem.func_190926_b()) {
            tag.func_82580_o("Item" + slot);
        } else {
            CompoundNBT compound = new CompoundNBT();
            containingItem.func_77955_b(compound);
            tag.func_218657_a("Item" + slot, (INBT)compound);
        }
        int current = TabletItem.getCurrentSlot(stack);
        ItemStack newTablet = TabletItem.deriveNewItemstack(slot, containingItem, stack, current);
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)newTablet);
    }

    private static ItemStack deriveNewItemstack(int slot, ItemStack containingItem, ItemStack stack, int current) {
        ItemStack newTablet;
        if (slot == current) {
            newTablet = containingItem.func_190926_b() ? new ItemStack((IItemProvider)TabletModule.TABLET.get()) : new ItemStack((IItemProvider)((ITabletSupport)containingItem.func_77973_b()).getInstalledTablet());
            newTablet.func_77982_d(stack.func_77978_p());
        } else {
            newTablet = stack;
        }
        return newTablet;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.openTabletGui(player);
            } else {
                ItemStack containingItem = TabletItem.getContainingItem(stack, TabletItem.getCurrentSlot(stack));
                if (containingItem.func_190926_b()) {
                    this.openTabletGui(player);
                } else if (containingItem.func_77973_b() instanceof ITabletSupport) {
                    ((ITabletSupport)containingItem.func_77973_b()).openGui(player, stack, containingItem);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private void openTabletGui(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

            @Nonnull
            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Tablet");
            }

            public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
                TabletContainer container = new TabletContainer(id, player.func_233580_cy_(), player);
                container.setupInventories((IItemHandler)new TabletItemHandler(player), playerInventory);
                return container;
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flags);
    }
}

