/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.varia;

import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class Box {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    private Box(Builder builder) {
        this.minX = builder.minX;
        this.minY = builder.minY;
        this.minZ = builder.minZ;
        this.maxX = builder.maxX;
        this.maxY = builder.maxY;
        this.maxZ = builder.maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public boolean isValid() {
        if (this.minX >= this.maxX) {
            return false;
        }
        if (this.minY >= this.maxY) {
            return false;
        }
        return this.minZ < this.maxZ;
    }

    public boolean in(BlockPos pos) {
        if (pos.func_177958_n() < this.minX || pos.func_177958_n() > this.maxX) {
            return false;
        }
        if (pos.func_177956_o() < this.minY || pos.func_177956_o() > this.maxY) {
            return false;
        }
        return pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ;
    }

    public BlockPos randomPos(Random random) {
        return new BlockPos(this.minX + random.nextInt(this.maxX - this.minX + 1), this.minY + random.nextInt(this.maxY - this.minY + 1), this.minZ + random.nextInt(this.maxZ - this.minZ + 1));
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        public Builder minimum(BlockPos pos) {
            this.minX = pos.func_177958_n();
            this.minY = pos.func_177956_o();
            this.minZ = pos.func_177952_p();
            return this;
        }

        public Builder maximum(BlockPos pos) {
            this.maxX = pos.func_177958_n();
            this.maxY = pos.func_177956_o();
            this.maxZ = pos.func_177952_p();
            return this;
        }

        public Builder center(BlockPos center, int radiusX, int radiusY, int radiusZ) {
            this.minX = center.func_177958_n() - radiusX;
            this.minY = center.func_177956_o() - radiusY;
            this.minZ = center.func_177952_p() - radiusZ;
            this.maxX = center.func_177958_n() + radiusX;
            this.maxY = center.func_177956_o() + radiusY;
            this.maxZ = center.func_177952_p() + radiusZ;
            return this;
        }

        public Builder clampY(int minimumY, int maximumY) {
            this.minY = Math.max(this.minY, minimumY);
            this.maxY = Math.min(this.maxY, maximumY);
            return this;
        }

        public Box build() {
            return new Box(this);
        }
    }
}

