/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.tools.rules.CommonRuleEvaluator;
import mcjty.tools.rules.CommonRuleKeys;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.Key;
import mcjty.tools.varia.LookAtTools;
import mcjty.tools.varia.Tools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class RuleBase<T extends EventGetter> {
    protected final Logger logger;
    protected final List<Consumer<T>> actions = new ArrayList<Consumer<T>>();
    private static Random rnd = new Random();
    private static Map<String, DamageSource> damageMap = null;

    public RuleBase(Logger logger) {
        this.logger = logger;
    }

    protected List<Pair<Float, ItemStack>> getItemsWeighted(List<String> itemNames) {
        ArrayList<Pair<Float, ItemStack>> items = new ArrayList<Pair<Float, ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Pair<Float, ItemStack> pair;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                pair = Tools.parseStackWithFactor(name, this.logger);
                if (((ItemStack)pair.getValue()).func_190926_b()) {
                    ErrorHandler.error("Unknown item '" + name + "'!");
                    continue;
                }
                items.add(pair);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                pair = Tools.parseStackWithFactor(obj, this.logger);
                if (pair == null) continue;
                items.add(pair);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    protected ItemStack getRandomItem(List<Pair<Float, ItemStack>> items, float total) {
        float r = rnd.nextFloat() * total;
        for (Pair<Float, ItemStack> pair : items) {
            if (r <= ((Float)pair.getLeft()).floatValue()) {
                return ((ItemStack)pair.getRight()).func_77946_l();
            }
            r -= ((Float)pair.getLeft()).floatValue();
        }
        return ItemStack.field_190927_a;
    }

    protected float getTotal(List<Pair<Float, ItemStack>> items) {
        float total = 0.0f;
        for (Pair<Float, ItemStack> pair : items) {
            total += ((Float)pair.getLeft()).floatValue();
        }
        return total;
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        if (map.has(CommonRuleKeys.ACTION_COMMAND)) {
            this.addCommandAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_ADDSTAGE)) {
            this.addAddStage(map, layer);
        }
        if (map.has(CommonRuleKeys.ACTION_REMOVESTAGE)) {
            this.addRemoveStage(map, layer);
        }
        if (map.has(CommonRuleKeys.ACTION_HEALTHSET) || map.has(CommonRuleKeys.ACTION_HEALTHMULTIPLY) || map.has(CommonRuleKeys.ACTION_HEALTHADD)) {
            this.addHealthAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SPEEDSET) || map.has(CommonRuleKeys.ACTION_SPEEDMULTIPLY) || map.has(CommonRuleKeys.ACTION_SPEEDADD)) {
            this.addSpeedAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_DAMAGESET) || map.has(CommonRuleKeys.ACTION_DAMAGEMULTIPLY) || map.has(CommonRuleKeys.ACTION_DAMAGEADD)) {
            this.addDamageAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SIZEMULTIPLY) || map.has(CommonRuleKeys.ACTION_SIZEADD)) {
            this.addSizeActions(map);
        }
        if (map.has(CommonRuleKeys.ACTION_POTION)) {
            this.addPotionsAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_ANGRY)) {
            this.addAngryAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_CUSTOMNAME)) {
            this.addCustomName(map);
        }
        if (map.has(CommonRuleKeys.ACTION_MOBNBT)) {
            this.addMobNBT(map);
        }
        if (map.has(CommonRuleKeys.ACTION_HELDITEM)) {
            this.addHeldItem(map);
        }
        if (map.has(CommonRuleKeys.ACTION_ARMORBOOTS)) {
            this.addArmorItem(map, CommonRuleKeys.ACTION_ARMORBOOTS, EquipmentSlotType.FEET);
        }
        if (map.has(CommonRuleKeys.ACTION_ARMORLEGS)) {
            this.addArmorItem(map, CommonRuleKeys.ACTION_ARMORLEGS, EquipmentSlotType.LEGS);
        }
        if (map.has(CommonRuleKeys.ACTION_ARMORHELMET)) {
            this.addArmorItem(map, CommonRuleKeys.ACTION_ARMORHELMET, EquipmentSlotType.HEAD);
        }
        if (map.has(CommonRuleKeys.ACTION_ARMORCHEST)) {
            this.addArmorItem(map, CommonRuleKeys.ACTION_ARMORCHEST, EquipmentSlotType.CHEST);
        }
        if (map.has(CommonRuleKeys.ACTION_FIRE)) {
            this.addFireAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_EXPLOSION)) {
            this.addExplosionAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_CLEAR)) {
            this.addClearAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_DAMAGE)) {
            this.addDoDamageAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_MESSAGE)) {
            this.addDoMessageAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_GIVE)) {
            this.addGiveAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_DROP)) {
            this.addDropAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SETBLOCK)) {
            this.addSetBlockAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SETHELDITEM)) {
            this.addSetHeldItemAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SETHELDAMOUNT)) {
            this.addSetHeldAmountAction(map);
        }
        if (map.has(CommonRuleKeys.ACTION_SETSTATE)) {
            if (layer.hasEnigmaScript()) {
                this.addStateAction(map, layer);
            } else {
                this.logger.warn("EnigmaScript is missing: this action cannot work!");
            }
        }
        if (map.has(CommonRuleKeys.ACTION_SETPSTATE)) {
            if (layer.hasEnigmaScript()) {
                this.addPStateAction(map, layer);
            } else {
                this.logger.warn("EnigmaScript is missing: this action cannot work!");
            }
        }
    }

    private static void addSource(DamageSource source) {
        damageMap.put(source.func_76355_l(), source);
    }

    private void createDamageMap() {
        if (damageMap == null) {
            damageMap = new HashMap<String, DamageSource>();
            RuleBase.addSource(DamageSource.field_76372_a);
            RuleBase.addSource(DamageSource.field_180137_b);
            RuleBase.addSource(DamageSource.field_76370_b);
            RuleBase.addSource(DamageSource.field_76371_c);
            RuleBase.addSource(DamageSource.field_190095_e);
            RuleBase.addSource(DamageSource.field_76368_d);
            RuleBase.addSource(DamageSource.field_191291_g);
            RuleBase.addSource(DamageSource.field_76369_e);
            RuleBase.addSource(DamageSource.field_76366_f);
            RuleBase.addSource(DamageSource.field_76367_g);
            RuleBase.addSource(DamageSource.field_76379_h);
            RuleBase.addSource(DamageSource.field_188406_j);
            RuleBase.addSource(DamageSource.field_76380_i);
            RuleBase.addSource(DamageSource.field_76377_j);
            RuleBase.addSource(DamageSource.field_76376_m);
            RuleBase.addSource(DamageSource.field_82727_n);
            RuleBase.addSource(DamageSource.field_82728_o);
            RuleBase.addSource(DamageSource.field_82729_p);
            RuleBase.addSource(DamageSource.field_188407_q);
        }
    }

    private void addCommandAction(AttributeMap map) {
        String command = map.get(CommonRuleKeys.ACTION_COMMAND);
        this.actions.add(event -> {});
    }

    private void addAddStage(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String stage = map.get(CommonRuleKeys.ACTION_ADDSTAGE);
        this.actions.add(event -> {
            PlayerEntity player = event.getPlayer();
            if (player != null) {
                layer.addGameStage(player, stage);
            }
        });
    }

    private void addRemoveStage(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String stage = map.get(CommonRuleKeys.ACTION_REMOVESTAGE);
        this.actions.add(event -> {
            PlayerEntity player = event.getPlayer();
            if (player != null) {
                layer.removeGameStage(player, stage);
            }
        });
    }

    private void addDoDamageAction(AttributeMap map) {
        String damage = map.get(CommonRuleKeys.ACTION_DAMAGE);
        this.createDamageMap();
        String[] split = StringUtils.split((String)damage, (String)"=");
        DamageSource source = damageMap.get(split[0]);
        if (source == null) {
            ErrorHandler.error("Can't find damage source '" + split[0] + "'!");
            return;
        }
        float amount = 1.0f;
        if (split.length > 1) {
            amount = Float.parseFloat(split[1]);
        }
        float finalAmount = amount;
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.func_70097_a(source, finalAmount);
            }
        });
    }

    private void addDoMessageAction(AttributeMap map) {
        String message = map.get(CommonRuleKeys.ACTION_MESSAGE);
        this.actions.add(event -> {
            PlayerEntity player = event.getPlayer();
            if (player == null) {
                player = event.getWorld().func_217362_a((Entity)event.getEntityLiving(), 100.0);
            }
            if (player != null) {
                player.func_146105_b((ITextComponent)new StringTextComponent(message), false);
            }
        });
    }

    private void addGiveAction(AttributeMap map) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(CommonRuleKeys.ACTION_GIVE));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                PlayerEntity player = event.getPlayer();
                if (player != null && !player.field_71071_by.func_70441_a(item.func_77946_l())) {
                    player.func_70099_a(item.func_77946_l(), 1.05f);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item;
                PlayerEntity player = event.getPlayer();
                if (player != null && !player.field_71071_by.func_70441_a((item = this.getRandomItem(items, total)).func_77946_l())) {
                    player.func_70099_a(item.func_77946_l(), 1.05f);
                }
            });
        }
    }

    private void addStateAction(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.ACTION_SETSTATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setState(event.getWorld(), finalState, finalValue));
    }

    private void addPStateAction(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String s = map.get(CommonRuleKeys.ACTION_SETPSTATE);
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setPlayerState(event.getPlayer(), finalState, finalValue));
    }

    @Nonnull
    private Function<EventGetter, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = 0;
            offsetY = 0;
            offsetZ = 0;
        }
        if (obj.has("look")) {
            return event -> {
                RayTraceResult result = LookAtTools.getMovingObjectPositionFromPlayer(event.getWorld(), event.getPlayer(), false);
                if (result instanceof BlockRayTraceResult) {
                    return ((BlockRayTraceResult)result).func_216350_a().func_177982_a(offsetX, offsetY, offsetZ);
                }
                return event.getPosition().func_177982_a(offsetX, offsetY, offsetZ);
            };
        }
        return event -> event.getPosition().func_177982_a(offsetX, offsetY, offsetZ);
    }

    private void addSetHeldItemAction(AttributeMap map) {
        ItemStack stack;
        JsonParser parser = new JsonParser();
        String json = map.get(CommonRuleKeys.ACTION_SETHELDITEM);
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String name = element.getAsString();
            stack = Tools.parseStack(name, this.logger);
        } else if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            stack = Tools.parseStack(obj, this.logger);
            if (stack == null) {
                return;
            }
        } else {
            ErrorHandler.error("Item description '" + json + "' is not valid!");
            return;
        }
        this.actions.add(event -> event.getPlayer().func_184611_a(Hand.MAIN_HAND, stack.func_77946_l()));
    }

    private void addSetHeldAmountAction(AttributeMap map) {
        String amount = map.get(CommonRuleKeys.ACTION_SETHELDAMOUNT);
        int add = 0;
        int set = -1;
        if (amount.startsWith("+")) {
            add = Integer.parseInt(amount.substring(1));
        } else if (amount.startsWith("-")) {
            add = -Integer.parseInt(amount.substring(1));
        } else {
            set = amount.startsWith("=") ? Integer.parseInt(amount.substring(1)) : Integer.parseInt(amount);
        }
        int finalSet = set;
        if (finalSet >= 0) {
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().func_184614_ca();
                item.func_190920_e(finalSet);
                event.getPlayer().func_184611_a(Hand.MAIN_HAND, item.func_77946_l());
            });
        } else {
            int finalAdd = add;
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().func_184614_ca();
                int newCount = item.func_190916_E() + finalAdd;
                if (newCount < 0) {
                    newCount = 0;
                } else if (newCount >= item.func_77976_d()) {
                    newCount = item.func_77976_d() - 1;
                }
                item.func_190920_e(newCount);
                event.getPlayer().func_184611_a(Hand.MAIN_HAND, item.func_77946_l());
            });
        }
    }

    private void addSetBlockAction(AttributeMap map) {
        Function<EventGetter, BlockPos> posFunction = map.has(CommonRuleKeys.BLOCKOFFSET) ? this.parseOffset(map.get(CommonRuleKeys.BLOCKOFFSET)) : EventGetter::getPosition;
        JsonParser parser = new JsonParser();
        String json = map.get(CommonRuleKeys.ACTION_SETBLOCK);
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.func_176223_P();
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().func_180501_a(pos, state, 3);
                }
            });
        } else {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.has("block")) {
                ErrorHandler.error("Block is not valid!");
                return;
            }
            String blockname = obj.get("block").getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.func_176223_P();
            if (obj.has("properties")) {
                JsonArray propArray = obj.get("properties").getAsJsonArray();
                for (JsonElement el : propArray) {
                    JsonObject propObj = el.getAsJsonObject();
                    String name = propObj.get("name").getAsString();
                    String value = propObj.get("value").getAsString();
                    for (Property key : state.func_235904_r_()) {
                        if (!name.equals(key.func_177701_a())) continue;
                        state = CommonRuleEvaluator.set(state, key, value);
                    }
                }
            }
            BlockState finalState = state;
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().func_180501_a(pos, finalState, 3);
                }
            });
        }
    }

    private void addDropAction(AttributeMap map) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(CommonRuleKeys.ACTION_DROP));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                if (event.getWorld() instanceof World) {
                    BlockPos pos = event.getPosition();
                    ItemEntity entityItem = new ItemEntity((World)event.getWorld(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), item.func_77946_l());
                    event.getWorld().func_217376_c((Entity)entityItem);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                if (event.getWorld() instanceof World) {
                    BlockPos pos = event.getPosition();
                    ItemStack item = this.getRandomItem(items, total);
                    ItemEntity entityItem = new ItemEntity((World)event.getWorld(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), item.func_77946_l());
                    event.getWorld().func_217376_c((Entity)entityItem);
                }
            });
        }
    }

    private void addClearAction(AttributeMap map) {
        Boolean clear = map.get(CommonRuleKeys.ACTION_CLEAR);
        if (clear.booleanValue()) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    living.func_195061_cb();
                }
            });
        }
    }

    private void addFireAction(AttributeMap map) {
        Integer fireAction = map.get(CommonRuleKeys.ACTION_FIRE);
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.func_70097_a(DamageSource.field_76370_b, 0.1f);
                living.func_70015_d(fireAction.intValue());
            }
        });
    }

    private void addExplosionAction(AttributeMap map) {
        String fireAction = map.get(CommonRuleKeys.ACTION_EXPLOSION);
        String[] split = StringUtils.split((String)fireAction, (String)",");
        float strength = 1.0f;
        boolean flaming = false;
        boolean smoking = false;
        try {
            strength = Float.parseFloat(split[0]);
            flaming = "1".equalsIgnoreCase(split[1]) || "true".equals(split[1].toLowerCase()) || "yes".equals(split[1].toLowerCase());
            smoking = "1".equalsIgnoreCase(split[2]) || "true".equals(split[2].toLowerCase()) || "yes".equals(split[2].toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        float finalStrength = strength;
        boolean finalFlaming = flaming;
        boolean finalSmoking = smoking;
        this.actions.add(event -> {
            BlockPos pos = event.getPosition();
            if (pos != null && event.getWorld() instanceof World) {
                ((World)event.getWorld()).func_217398_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, finalStrength, finalFlaming, Explosion.Mode.DESTROY);
            }
        });
    }

    private void addPotionsAction(AttributeMap map) {
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (String p : map.getList(CommonRuleKeys.ACTION_POTION)) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                ErrorHandler.error("Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(splitted[0]));
            if (potion == null) {
                ErrorHandler.error("Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                ErrorHandler.error("Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new EffectInstance(potion, duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    for (EffectInstance effect : effects) {
                        EffectInstance neweffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c());
                        living.func_195064_c(neweffect);
                    }
                }
            });
        }
    }

    private void addHealthAction(AttributeMap map) {
        if (map.has(CommonRuleKeys.ACTION_HEALTHSET)) {
            float s = map.get(CommonRuleKeys.ACTION_HEALTHSET).floatValue();
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlHealth") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233818_a_)) != null) {
                    entityAttribute.func_111128_a((double)s);
                    entityLiving.func_70606_j((float)((double)s));
                    entityLiving.func_184211_a("ctrlHealth");
                }
            });
        } else {
            float m = map.has(CommonRuleKeys.ACTION_HEALTHMULTIPLY) ? map.get(CommonRuleKeys.ACTION_HEALTHMULTIPLY).floatValue() : 1.0f;
            float a = map.has(CommonRuleKeys.ACTION_HEALTHADD) ? map.get(CommonRuleKeys.ACTION_HEALTHADD).floatValue() : 0.0f;
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlHealth") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233818_a_)) != null) {
                    double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                    entityAttribute.func_111128_a(newMax);
                    entityLiving.func_70606_j((float)newMax);
                    entityLiving.func_184211_a("ctrlHealth");
                }
            });
        }
    }

    private void addSpeedAction(AttributeMap map) {
        if (map.has(CommonRuleKeys.ACTION_SPEEDSET)) {
            float s = map.get(CommonRuleKeys.ACTION_SPEEDSET).floatValue();
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlSpeed") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233821_d_)) != null) {
                    entityAttribute.func_111128_a((double)s);
                    entityLiving.func_184211_a("ctrlSpeed");
                }
            });
        } else {
            float m = map.has(CommonRuleKeys.ACTION_SPEEDMULTIPLY) ? map.get(CommonRuleKeys.ACTION_SPEEDMULTIPLY).floatValue() : 1.0f;
            float a = map.has(CommonRuleKeys.ACTION_SPEEDADD) ? map.get(CommonRuleKeys.ACTION_SPEEDADD).floatValue() : 0.0f;
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlSpeed") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233821_d_)) != null) {
                    double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                    entityAttribute.func_111128_a(newMax);
                    entityLiving.func_184211_a("ctrlSpeed");
                }
            });
        }
    }

    private void addSizeActions(AttributeMap map) {
        ErrorHandler.error("Mob resizing not implemented yet!");
        float m = map.has(CommonRuleKeys.ACTION_SIZEMULTIPLY) ? map.get(CommonRuleKeys.ACTION_SIZEMULTIPLY).floatValue() : 1.0f;
        float a = map.has(CommonRuleKeys.ACTION_SIZEADD) ? map.get(CommonRuleKeys.ACTION_SIZEADD).floatValue() : 0.0f;
        this.actions.add(event -> {
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null) {
                // empty if block
            }
        });
    }

    private void addDamageAction(AttributeMap map) {
        if (map.has(CommonRuleKeys.ACTION_DAMAGESET)) {
            float s = map.get(CommonRuleKeys.ACTION_DAMAGESET).floatValue();
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlDamage") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233823_f_)) != null) {
                    entityAttribute.func_111128_a((double)s);
                    entityLiving.func_184211_a("ctrlDamage");
                }
            });
        } else {
            float m = map.has(CommonRuleKeys.ACTION_DAMAGEMULTIPLY) ? map.get(CommonRuleKeys.ACTION_DAMAGEMULTIPLY).floatValue() : 1.0f;
            float a = map.has(CommonRuleKeys.ACTION_DAMAGEADD) ? map.get(CommonRuleKeys.ACTION_DAMAGEADD).floatValue() : 0.0f;
            this.actions.add(event -> {
                ModifiableAttributeInstance entityAttribute;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && !entityLiving.func_184216_O().contains("ctrlDamage") && (entityAttribute = entityLiving.func_110148_a(Attributes.field_233823_f_)) != null) {
                    double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                    entityAttribute.func_111128_a(newMax);
                    entityLiving.func_184211_a("ctrlDamage");
                }
            });
        }
    }

    private void addArmorItem(AttributeMap map, Key<String> itemKey, EquipmentSlotType slot) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(itemKey));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.func_184201_a(slot, item.func_77946_l());
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.func_184201_a(slot, this.getRandomItem(items, total));
                }
            });
        }
    }

    private void addHeldItem(AttributeMap map) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(CommonRuleKeys.ACTION_HELDITEM));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    if (entityLiving instanceof EndermanEntity) {
                        if (item.func_77973_b() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.func_77973_b();
                            ((EndermanEntity)entityLiving).func_195406_b(b.func_179223_d().func_176223_P());
                        }
                    } else {
                        entityLiving.func_184611_a(Hand.MAIN_HAND, item.func_77946_l());
                    }
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    ItemStack item = this.getRandomItem(items, total);
                    if (entityLiving instanceof EndermanEntity) {
                        if (item.func_77973_b() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.func_77973_b();
                            ((EndermanEntity)entityLiving).func_195406_b(b.func_179223_d().func_176223_P());
                        }
                    } else {
                        entityLiving.func_184611_a(Hand.MAIN_HAND, item.func_77946_l());
                    }
                }
            });
        }
    }

    private void addMobNBT(AttributeMap map) {
        String mobnbt = map.get(CommonRuleKeys.ACTION_MOBNBT);
        if (mobnbt != null) {
            CompoundNBT tagCompound;
            try {
                tagCompound = JsonToNBT.func_180713_a((String)mobnbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Bad NBT for mob!");
                return;
            }
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.func_70037_a(tagCompound);
            });
        }
    }

    private void addCustomName(AttributeMap map) {
        String customName = map.get(CommonRuleKeys.ACTION_CUSTOMNAME);
        if (customName != null) {
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.func_200203_b((ITextComponent)new StringTextComponent(customName));
            });
        }
    }

    private void addAngryAction(AttributeMap map) {
        if (map.get(CommonRuleKeys.ACTION_ANGRY).booleanValue()) {
            this.actions.add(event -> {
                PlayerEntity player;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving instanceof LivingEntity && (player = event.getWorld().func_217362_a((Entity)entityLiving, 50.0)) != null) {
                    entityLiving.func_70604_c((LivingEntity)player);
                    entityLiving.func_130011_c((Entity)player);
                    if (entityLiving instanceof IAngerable) {
                        ((IAngerable)entityLiving).func_70624_b((LivingEntity)player);
                    }
                }
            });
        }
    }

    public static interface EventGetter {
        public LivingEntity getEntityLiving();

        public PlayerEntity getPlayer();

        public IWorld getWorld();

        public BlockPos getPosition();
    }
}

