/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.cache;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import mcjty.tools.cache.StructureCacheEntry;
import mcjty.tools.varia.Tools;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class StructureCache {
    public static final StructureCache CACHE = new StructureCache();
    private final Map<StructureCacheEntry, Boolean> structureCache = new HashMap<StructureCacheEntry, Boolean>();

    public void clean() {
        this.structureCache.clear();
    }

    public boolean isInStructure(IWorld world, String structure, BlockPos pos) {
        RegistryKey<World> dimension = Tools.getDimensionKey(world);
        ChunkPos cp = new ChunkPos(pos);
        long cplong = ChunkPos.func_77272_a((int)cp.field_77276_a, (int)cp.field_77275_b);
        StructureCacheEntry entry = new StructureCacheEntry(structure, dimension, cplong);
        if (this.structureCache.containsKey(entry)) {
            return this.structureCache.get(entry);
        }
        ServerWorld sw = Tools.getServerWorld(world);
        IChunk chunk = sw.func_217353_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222607_c, false);
        if (chunk == null) {
            return false;
        }
        Map references = chunk.func_201604_d();
        for (Map.Entry e : references.entrySet()) {
            LongSet longs = (LongSet)e.getValue();
            if (longs.isEmpty()) continue;
            this.structureCache.put(new StructureCacheEntry(((Structure)e.getKey()).getRegistryName().toString(), dimension, cplong), true);
        }
        if (this.structureCache.containsKey(entry)) {
            return true;
        }
        this.structureCache.put(entry, false);
        return false;
    }
}

