/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import java.util.HashMap;
import java.util.Map;
import mcjty.tools.varia.Tools;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RuleCache {
    private Map<RegistryKey<World>, CachePerWorld> caches = new HashMap<RegistryKey<World>, CachePerWorld>();

    public void reset(IWorld world) {
        RegistryKey<World> key = Tools.getDimensionKey(world);
        CachePerWorld cache = this.caches.get(key);
        if (cache != null) {
            cache.reset();
        }
    }

    public int getValidSpawnChunks(IWorld world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidSpawnChunks(world);
    }

    public int getValidPlayers(IWorld world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidPlayers(world);
    }

    public int getCountPassive(IWorld world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountPassive(world);
    }

    public int getCountHostile(IWorld world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountHostile(world);
    }

    public int getCountNeutral(IWorld world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountNeutral(world);
    }

    public int getCount(IWorld world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        int count = cache.getCount(world, entityType);
        return count;
    }

    public int getCountPerMod(IWorld world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.total;
    }

    public int getCountPerModHostile(IWorld world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.hostile;
    }

    public int getCountPerModPassive(IWorld world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.passive;
    }

    public void registerSpawn(IWorld world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerSpawn(world, entityType);
    }

    public void registerDespawn(IWorld world, EntityType entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerDespawn(world, entityType);
    }

    private CachePerWorld getOrCreateCache(IWorld world) {
        RegistryKey<World> key = Tools.getDimensionKey(world);
        CachePerWorld cache = this.caches.get(key);
        if (cache == null) {
            cache = new CachePerWorld();
            this.caches.put(key, cache);
        }
        return cache;
    }

    private class CachePerWorld {
        private Map<EntityType, Integer> cachedCounters = new HashMap<EntityType, Integer>();
        private Map<String, CountPerMod> countPerMod = new HashMap<String, CountPerMod>();
        private int countPassive = -1;
        private int countHostile = -1;
        private int countNeutral = -1;
        private int validSpawnChunks = -1;
        private int validPlayers = -1;
        private boolean countDone = false;

        private CachePerWorld() {
        }

        public void reset() {
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = -1;
            this.countHostile = -1;
            this.countNeutral = -1;
            this.validSpawnChunks = -1;
            this.validPlayers = -1;
            this.countDone = false;
        }

        public int getValidSpawnChunks(IWorld world) {
            if (this.validSpawnChunks == -1) {
                this.validSpawnChunks = this.countValidSpawnChunks(world);
            }
            return this.validSpawnChunks;
        }

        public int getValidPlayers(IWorld world) {
            if (this.validPlayers == -1) {
                this.validPlayers = this.countValidPlayers(world);
            }
            return this.validPlayers;
        }

        private int countValidPlayers(IWorld world) {
            int cnt = 0;
            for (PlayerEntity entityplayer : world.func_217369_A()) {
                if (entityplayer.func_175149_v()) continue;
                ++cnt;
            }
            return cnt;
        }

        private int countValidSpawnChunks(IWorld world) {
            ServerWorld sw = Tools.getServerWorld(world);
            return sw.func_72863_F().field_217237_a.func_219194_d();
        }

        public int getCountPassive(IWorld world) {
            this.count(world);
            return this.countPassive;
        }

        public int getCountHostile(IWorld world) {
            this.count(world);
            return this.countHostile;
        }

        public int getCountNeutral(IWorld world) {
            this.count(world);
            return this.countNeutral;
        }

        private void count(IWorld world) {
            if (this.countDone) {
                return;
            }
            this.countDone = true;
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = 0;
            this.countHostile = 0;
            this.countNeutral = 0;
            ServerWorld sw = Tools.getServerWorld(world);
            sw.getEntities().forEach(entity -> {
                if (entity instanceof MobEntity) {
                    int cnt = this.cachedCounters.getOrDefault(entity.func_200600_R(), 0) + 1;
                    this.cachedCounters.put(entity.func_200600_R(), cnt);
                    String mod = entity.func_200600_R().getRegistryName().func_110624_b();
                    CountPerMod count = this.countPerMod.computeIfAbsent(mod, s -> new CountPerMod());
                    count.total++;
                    if (entity instanceof IMob) {
                        count.hostile++;
                        ++this.countHostile;
                    } else if (entity instanceof AnimalEntity) {
                        count.passive++;
                        ++this.countPassive;
                    } else {
                        count.neutral++;
                        ++this.countNeutral;
                    }
                }
            });
        }

        public int getCount(IWorld world, EntityType entityType) {
            this.count(world);
            return this.cachedCounters.getOrDefault(entityType, 0);
        }

        public CountPerMod getCountPerMod(IWorld world, String mod) {
            this.count(world);
            return this.countPerMod.get(mod);
        }

        public void registerSpawn(IWorld world, EntityType entityType) {
            this.count(world);
            this.cachedCounters.put(entityType, this.cachedCounters.getOrDefault(entityType, 0) + 1);
        }

        public void registerDespawn(IWorld world, EntityType entityType) {
            this.count(world);
            Integer cnt = this.cachedCounters.getOrDefault(entityType, 0);
            if (cnt > 0) {
                this.cachedCounters.put(entityType, cnt - 1);
            }
        }
    }

    private static class CountPerMod {
        private int hostile;
        private int passive;
        private int neutral;
        private int total;

        private CountPerMod() {
        }
    }
}

