/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.Set;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.Event;

public class ExperienceRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<LivingExperienceDropEvent> EVENT_QUERY = new IEventQuery<LivingExperienceDropEvent>(){

        public World getWorld(LivingExperienceDropEvent o) {
            return o.getEntity().func_130014_f_();
        }

        @Override
        public BlockPos getPos(LivingExperienceDropEvent o) {
            return o.getEntity().func_233580_cy_();
        }

        @Override
        public BlockPos getValidBlockPos(LivingExperienceDropEvent o) {
            return o.getEntity().func_233580_cy_().func_177977_b();
        }

        @Override
        public int getY(LivingExperienceDropEvent o) {
            return o.getEntity().func_233580_cy_().func_177956_o();
        }

        @Override
        public Entity getEntity(LivingExperienceDropEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(LivingExperienceDropEvent o) {
            return null;
        }

        @Override
        public Entity getAttacker(LivingExperienceDropEvent o) {
            return o.getAttackingPlayer();
        }

        @Override
        public PlayerEntity getPlayer(LivingExperienceDropEvent o) {
            return o.getAttackingPlayer();
        }

        @Override
        public ItemStack getItem(LivingExperienceDropEvent o) {
            return ItemStack.field_190927_a;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private final GenericRuleEvaluator ruleEvaluator;
    private final Set<String> phases;
    private Event.Result result;
    private Integer xp = null;
    private float multxp = 1.0f;
    private float addxp = 0.0f;

    private ExperienceRule(AttributeMap map, Set<String> phases) {
        super(InControl.setup.getLogger());
        this.phases = phases;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public static ExperienceRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new ExperienceRule(map, PhaseTools.getPhases(element));
    }

    public int modifyXp(int xpIn) {
        if (this.xp != null) {
            xpIn = this.xp;
        }
        return (int)((float)xpIn * this.multxp + this.addxp);
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
        if (map.has(RuleKeys.ACTION_SETXP)) {
            this.xp = map.get(RuleKeys.ACTION_SETXP);
        }
        if (map.has(RuleKeys.ACTION_ADDXP)) {
            this.addxp = map.get(RuleKeys.ACTION_ADDXP).floatValue();
        }
        if (map.has(RuleKeys.ACTION_MULTXP)) {
            this.multxp = map.get(RuleKeys.ACTION_MULTXP).floatValue();
        }
    }

    public boolean match(LivingExperienceDropEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public Event.Result getResult() {
        return this.result;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.CATEGORY)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.PLAYER)).attribute(Attribute.create(RuleKeys.REALPLAYER)).attribute(Attribute.create(RuleKeys.FAKEPLAYER)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.create(RuleKeys.PSTATE)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.createMulti(RuleKeys.HELDITEM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_SETXP)).attribute(Attribute.create(RuleKeys.ACTION_ADDXP)).attribute(Attribute.create(RuleKeys.ACTION_MULTXP));
    }
}

