/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.woodcutter.WoodCutterMod;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.item.WoodcutterItem;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    public static final Set<Item> WOODCUTTER_ITEMS = new HashSet<Item>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.field_190927_a;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        for (VanillaWoodVariant vanillaWoodVariant : VanillaWoodVariant.values()) {
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), vanillaWoodVariant.func_176610_l());
        }
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            for (Enum enum_ : BOPWoodVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), ((BOPWoodVariant)enum_).func_176610_l());
            }
        }
        if (SupportMods.QUARK.isLoaded()) {
            for (Enum enum_ : QuarkWoodVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), ((QuarkWoodVariant)enum_).func_176610_l() + "_stained");
            }
        }
        if (SupportMods.TWILIGHT_FOREST.isLoaded()) {
            for (Enum enum_ : TFWoodVariant.values()) {
                ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), ((TFWoodVariant)enum_).func_176610_l());
            }
        }
        if (SupportMods.TROPICRAFT.isLoaded()) {
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.TROPICRAFT.func_176610_l() + "_" + TropicraftVariant.PALM.func_176610_l());
            ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.TROPICRAFT.func_176610_l() + "_" + TropicraftVariant.MAHOGANY.func_176610_l());
        }
        if (SupportMods.BYG.isLoaded()) {
            if (SupportMods.EXTENSION_BYG.isLoaded()) {
                for (Enum enum_ : BYGWoodVariant.values()) {
                    ModBlocks.registerWoodcutter((IForgeRegistry<Block>)event.getRegistry(), SupportMods.BYG.func_176610_l() + "_" + ((BYGWoodVariant)enum_).func_176610_l());
                }
            } else {
                WoodCutterMod.LOGGER.info("missing extension for \"Oh Biome You'll Go\" recipes");
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterBlockItems(RegistryEvent.Register<Item> event) {
        WOODCUTTERS.forEach(woodcutterBlock -> {
            Item woodcutter = (Item)new WoodcutterItem((Block)woodcutterBlock).setRegistryName(Objects.requireNonNull(woodcutterBlock.getRegistryName()));
            WOODCUTTER_ITEMS.add(woodcutter);
            event.getRegistry().register((IForgeRegistryEntry)woodcutter);
        });
    }

    private static void registerWoodcutter(IForgeRegistry<Block> registry, String name) {
        Block woodcutter = (Block)new WoodcutterBlock().setRegistryName("corail_woodcutter", name + "_woodcutter");
        registry.register((IForgeRegistryEntry)woodcutter);
        WOODCUTTERS.add(woodcutter);
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.func_190926_b()) {
            RANDOM_STACK = new ItemStack((IItemProvider)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.field_222430_lS));
        }
        return RANDOM_STACK;
    }

    public static enum BYGWoodVariant implements IStringSerializable
    {
        ASPEN,
        BAOBAB,
        BLUE_ENCHANTED,
        CHERRY,
        CIKA,
        CYPRESS,
        EBONY,
        FIR,
        GREEN_ENCHANTED,
        HOLLY,
        JACARANDA,
        MAHOGANY,
        MANGROVE,
        MAPLE,
        PINE,
        RAINBOW_EUCALYPTUS,
        REDWOOD,
        SKYRIS,
        WILLOW,
        WITCH_HAZEL,
        ZELKOVA,
        SYTHIAN,
        EMBUR,
        PALM,
        LAMENT,
        BULBIS,
        NIGHTSHADE,
        ETHER,
        IMPARIUS;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum TropicraftVariant implements IStringSerializable
    {
        PALM,
        MAHOGANY,
        BAMBOO,
        THATCH;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum TFWoodVariant implements IStringSerializable
    {
        TWILIGHT_OAK,
        CANOPY,
        MANGROVE,
        DARK,
        TIME,
        TRANS,
        MINE,
        SORT;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum QuarkWoodVariant implements IStringSerializable
    {
        BLACK,
        BLUE,
        BROWN,
        CYAN,
        GRAY,
        GREEN,
        LIGHT_BLUE,
        LIGHT_GRAY,
        LIME,
        MAGENTA,
        ORANGE,
        PINK,
        PURPLE,
        RED,
        WHITE,
        YELLOW;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum BOPWoodVariant implements IStringSerializable
    {
        CHERRY,
        DEAD,
        FIR,
        HELLBARK,
        JACARANDA,
        MAGIC,
        MAHOGANY,
        PALM,
        REDWOOD,
        UMBRAN,
        WILLOW;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum VanillaWoodVariant implements IStringSerializable
    {
        OAK,
        BIRCH,
        SPRUCE,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        CRIMSON,
        WARPED;

        private final String name = this.name().toLowerCase(Locale.US);

        public String func_176610_l() {
            return this.name;
        }
    }
}

