/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModXRegistration
extends ModX {
    private final List<Runnable> registrationHandlers = new ArrayList<Runnable>();
    private boolean registered = false;
    private final List<Pair<String, Object>> registerables = new ArrayList<Pair<String, Object>>();

    protected ModXRegistration(String modid, ItemGroup tab) {
        super(modid, tab);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonRegistration);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistration);
        try {
            Method method = EventBus.class.getDeclaredMethod("addListener", EventPriority.class, Predicate.class, Class.class, Consumer.class);
            method.setAccessible(true);
            method.invoke((Object)FMLJavaModLoadingContext.get().getModEventBus(), EventPriority.NORMAL, obj -> true, RegistryEvent.Register.class, this::onRegistry);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("could not add generic listener to listen all registry events for mod " + modid + ".", e);
        }
        this.callGeneratedCode();
    }

    public final void addRegistrationHandler(Runnable handler) {
        this.registrationHandlers.add(handler);
    }

    public final void register(String id, Object obj) {
        if (!ResourceLocation.func_217856_c((String)id)) {
            throw new IllegalArgumentException("ModXRegistration#register called with invalid id argument.");
        }
        this.registerables.add((Pair<String, Object>)Pair.of((Object)id, (Object)obj));
        if (obj instanceof Registerable) {
            ((Registerable)obj).getAdditionalRegisters().forEach(o -> this.register(id, o));
            ((Registerable)obj).getNamedAdditionalRegisters().forEach((str, o) -> this.register(id + "_" + str, o));
        }
    }

    private void runRegistration() {
        if (!this.registered) {
            this.registered = true;
            this.registrationHandlers.forEach(Runnable::run);
        }
    }

    private void commonRegistration(FMLCommonSetupEvent event) {
        this.runRegistration();
        this.registerables.stream().filter(pair -> pair.getRight() instanceof Registerable).forEach(pair -> ((Registerable)pair.getRight()).registerCommon(new ResourceLocation(this.modid, (String)pair.getLeft()), arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
    }

    private void clientRegistration(FMLClientSetupEvent event) {
        this.runRegistration();
        this.registerables.stream().filter(pair -> pair.getRight() instanceof Registerable).forEach(pair -> ((Registerable)pair.getRight()).registerClient(new ResourceLocation(this.modid, (String)pair.getLeft()), arg_0 -> ((FMLClientSetupEvent)event).enqueueWork(arg_0)));
    }

    private void onRegistry(RegistryEvent.Register<? extends IForgeRegistryEntry<?>> event) {
        this.runRegistration();
        this.registerables.stream().filter(pair -> event.getRegistry().getRegistrySuperType().isAssignableFrom(pair.getRight().getClass())).forEach(pair -> {
            ((IForgeRegistryEntry)pair.getRight()).setRegistryName(new ResourceLocation(this.modid, (String)pair.getLeft()));
            event.getRegistry().register((IForgeRegistryEntry)pair.getRight());
        });
    }
}

