/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.ItemBase;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemInventory<T extends IItemHandlerModifiable & INBTSerializable<CompoundNBT>>
extends ItemBase {
    private final Function<Runnable, T> inventoryFactory;

    public ItemInventory(ModX mod, Item.Properties properties, Function<Runnable, T> inventoryFactory) {
        super(mod, properties);
        this.inventoryFactory = inventoryFactory;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT capTag) {
        final LazyOptional inventoryCapability = LazyOptional.of(() -> {
            AtomicReference<Object> handler = new AtomicReference<Object>(null);
            handler.set(this.inventoryFactory.apply(() -> {
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_218657_a("Inventory", ((INBTSerializable)((IItemHandlerModifiable)handler.get())).serializeNBT());
                stack.func_77982_d(nbt);
            }));
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b("Inventory", 10)) {
                ((INBTSerializable)((IItemHandlerModifiable)handler.get())).deserializeNBT((INBT)nbt.func_74775_l("Inventory"));
            }
            return handler.get();
        });
        return new ICapabilityProvider(){

            @Nonnull
            public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? inventoryCapability : LazyOptional.empty();
            }
        };
    }

    @Nullable
    public static IItemHandlerModifiable getInventory(ItemStack stack) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null);
        if (handler instanceof IItemHandlerModifiable) {
            return (IItemHandlerModifiable)handler;
        }
        return null;
    }

    public static Stream<IItemHandlerModifiable> getInventoryStream(ItemStack stack) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null);
        if (handler instanceof IItemHandlerModifiable) {
            return Stream.of((IItemHandlerModifiable)handler);
        }
        return Stream.empty();
    }
}

