/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.noeppi_noeppi.libx.command.CommandUtil;
import io.github.noeppi_noeppi.libx.impl.commands.NbtOutputType;
import io.github.noeppi_noeppi.libx.util.IdToTextComponent;
import io.github.noeppi_noeppi.libx.util.JsonToTextComponent;
import io.github.noeppi_noeppi.libx.util.NbtToJson;
import io.github.noeppi_noeppi.libx.util.NbtToTextComponent;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class HandCommand
implements Command<CommandSource> {
    public int run(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CompoundNBT nbt;
        int count;
        Item item;
        NbtOutputType format = CommandUtil.getArgumentOrDefault(ctx, "output_format", NbtOutputType.class, NbtOutputType.NBT);
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_190926_b() || stack.func_77973_b().getRegistryName() == null) {
            item = Items.field_190931_a;
            count = 0;
            nbt = null;
        } else {
            item = stack.func_77973_b();
            count = stack.func_190916_E();
            nbt = stack.func_77978_p();
        }
        NBTPathArgument.NBTPath path = CommandUtil.getArgumentOrDefault(ctx, "nbt_path", NBTPathArgument.NBTPath.class, null);
        IFormattableTextComponent tc = IdToTextComponent.toText(item.getRegistryName());
        if (count != 1) {
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(count)));
        }
        if (nbt != null && !nbt.isEmpty()) {
            List printNBT = Collections.singletonList(nbt);
            if (path != null) {
                printNBT = path.func_218071_a((INBT)nbt);
            }
            for (INBT element : printNBT) {
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)(format == NbtOutputType.NBT ? NbtToTextComponent.toText((INBT)nbt) : JsonToTextComponent.toText(NbtToJson.getJson(element, true))));
            }
        }
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)tc, true);
        return 0;
    }
}

