/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.event;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public abstract class RandomTickEvent
extends Event {
    private final World world;
    private final BlockPos pos;
    private final Random rand;

    private RandomTickEvent(World world, BlockPos pos, Random rand) {
        this.world = world;
        this.pos = pos;
        this.rand = rand;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Random getRand() {
        return this.rand;
    }

    public final boolean isCancelable() {
        return true;
    }

    public static class Fluid
    extends RandomTickEvent {
        private final FluidState state;

        public Fluid(FluidState state, World world, BlockPos pos, Random rand) {
            super(world, pos, rand);
            this.state = state;
        }

        public FluidState getState() {
            return this.state;
        }
    }

    public static class Block
    extends RandomTickEvent {
        private final BlockState state;
        private final ServerWorld serverWorld;

        public Block(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
            super((World)world, pos, rand);
            this.state = state;
            this.serverWorld = world;
        }

        public BlockState getState() {
            return this.state;
        }

        public ServerWorld getServerWorld() {
            return this.serverWorld;
        }
    }
}

