/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.impl.loot.AllLootEntry;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.GroupLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.SequenceLootEntry;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyBlockState;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BlockLootProviderBase
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ModX mod;
    protected final DataGenerator generator;
    private final Set<Block> blacklist = new HashSet<Block>();
    private final Map<Block, Function<Block, LootTable.Builder>> functionMap = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProviderBase(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    protected void customLootTable(Block block) {
        this.blacklist.add(block);
    }

    protected void customLootTable(Block block, LootTable.Builder loot) {
        this.functionMap.put(block, b -> loot);
    }

    protected void customLootTable(Block block, Function<Block, LootTable.Builder> loot) {
        this.functionMap.put(block, loot);
    }

    @Nonnull
    public final String func_200397_b() {
        return this.mod.modid + " block loot tables";
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        this.setup();
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (ResourceLocation resourceLocation : ForgeRegistries.BLOCKS.getKeys()) {
            Function<Block, LootTable.Builder> loot;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (block == null || !this.mod.modid.equals(resourceLocation.func_110624_b()) || this.blacklist.contains(block)) continue;
            if (this.functionMap.containsKey(block)) {
                loot = this.functionMap.get(block);
            } else {
                LootTable.Builder builder = this.defaultBehavior(block);
                Function<Block, LootTable.Builder> function = loot = builder == null ? null : b -> builder;
            }
            if (loot == null) continue;
            tables.put(resourceLocation, loot.apply(block));
        }
        for (Map.Entry entry : tables.entrySet()) {
            Path path = BlockLootProviderBase.getPath(this.generator.func_200391_b(), (ResourceLocation)entry.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)entry.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
    }

    protected abstract void setup();

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    public LootModifier copyNBT(String ... tags) {
        return (b, entry) -> {
            CopyNbt.Builder func = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY);
            for (String tag : tags) {
                func = func.func_216056_a(tag, "BlockEntityTag." + tag);
            }
            return entry.func_212841_b_((ILootFunction.IBuilder)func);
        };
    }

    public LootModifier copyProperties(Property<?> ... properties) {
        return (b, entry) -> {
            CopyBlockState.Builder func = CopyBlockState.func_227545_a_((Block)b);
            for (Property property : properties) {
                func = func.func_227552_a_(property);
            }
            return entry.func_212841_b_((ILootFunction.IBuilder)func);
        };
    }

    public void drops(Block b, boolean silk, ItemStack ... drops) {
        LootFactory[] loot = new LootFactory[drops.length];
        for (int i = 0; i < drops.length; ++i) {
            loot[i] = this.stack(drops[i]);
        }
        this.drops(b, silk, loot);
    }

    public void drops(Block b, boolean silk, LootEntry.Builder<?> ... loot) {
        this.drops(b, silk, LootFactory.from(loot));
    }

    public void drops(Block b, boolean silk, LootFactory ... loot) {
        this.drops(b, silk ? this.silk(LootModifier.identity()) : this.noSilk(), loot);
    }

    public void drops(Block b, LootFactory ... loot) {
        this.drops(b, this.noSilk(), loot);
    }

    public void drops(Block b, SilkModifier silk, LootFactory ... loot) {
        AlternativesLootEntry.Builder entry = this.combine(LootFactory.resolve(b, loot));
        if (silk.modifier != null) {
            LootEntry.Builder<?> silkBuilder = silk.modifier.apply(b, (StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)b).func_212840_b_(this.silkCondition()));
            entry = AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{silkBuilder, entry});
        }
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        this.customLootTable(b, LootTable.func_216119_b().func_216040_a(pool));
    }

    public StandaloneLootFactory item() {
        return StandaloneLootFactory.item();
    }

    public SilkModifier silk(GenericLootModifier modifier) {
        return new SilkModifier(modifier);
    }

    public SilkModifier noSilk() {
        return new SilkModifier(null);
    }

    public LootFactory repeat(LootFactory factory, int times) {
        LootFactory[] factories = new LootFactory[times];
        for (int i = 0; i < times; ++i) {
            factories[i] = factory;
        }
        return this.combine(factories);
    }

    public WrappedLootEntry from(StandaloneLootEntry.Builder<?> entry) {
        return new WrappedLootEntry(entry);
    }

    public LootFactory from(LootEntry.Builder<?> entry) {
        return LootFactory.from(entry);
    }

    public LootModifier from(LootFunction.Builder<?> function) {
        return (b, e) -> e.func_212841_b_((ILootFunction.IBuilder)function);
    }

    public LootModifier fortuneOres() {
        return (b, e) -> e.func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t));
    }

    public LootModifier fortuneUniform() {
        return this.fortuneUniform(1);
    }

    public LootModifier fortuneUniform(int multiplier) {
        return (b, e) -> e.func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)multiplier));
    }

    public LootModifier fortuneBinomial(float probability) {
        return this.fortuneBinomial(probability, 0);
    }

    public LootModifier fortuneBinomial(float probability, int bonus) {
        return (b, e) -> e.func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)probability, (int)bonus));
    }

    public ILootCondition.IBuilder random(float chance) {
        return RandomChance.func_216004_a((float)chance);
    }

    public ILootCondition.IBuilder randomFortune(float baseChance) {
        return this.randomFortune(baseChance, baseChance * 1.1111112f, baseChance * 1.25f, baseChance * 1.6666666f, baseChance * 5.0f);
    }

    public ILootCondition.IBuilder randomFortune(float baseChance, float ... levelChances) {
        float[] chances = new float[levelChances.length + 1];
        chances[0] = baseChance;
        System.arraycopy(levelChances, 0, chances, 1, levelChances.length);
        return TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances);
    }

    public LootModifier count(int count) {
        return this.from(SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)count)));
    }

    public LootModifier count(int min, int max) {
        if (min == max) {
            return this.from(SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)min)));
        }
        return this.from(SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
    }

    public LootModifier countBinomial(float chance, int num) {
        return this.from(SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)num, (float)chance)));
    }

    public ILootCondition.IBuilder not(ILootCondition.IBuilder condition) {
        return Inverted.func_215979_a((ILootCondition.IBuilder)condition);
    }

    public ILootCondition.IBuilder or(ILootCondition.IBuilder ... conditions) {
        return Alternative.func_215960_a((ILootCondition.IBuilder[])conditions);
    }

    public AllLootBuilder all() {
        return new AllLootBuilder(new LootEntry.Builder[0]);
    }

    public GroupLootBuilder group() {
        return new GroupLootBuilder(new LootEntry.Builder[0]);
    }

    public SequenceLootBuilder sequence() {
        return new SequenceLootBuilder(new LootEntry.Builder[0]);
    }

    private LootEntry.Builder<?> combineBy(Function<LootEntry.Builder<?>[], LootEntry.Builder<?>> combineFunc, LootEntry.Builder<?>[] loot) {
        if (loot.length == 0) {
            return EmptyLootEntry.func_216167_a();
        }
        if (loot.length == 1) {
            return loot[0];
        }
        return combineFunc.apply(loot);
    }

    private LootFactory combineBy(Function<LootEntry.Builder<?>[], LootEntry.Builder<?>> combineFunc, LootFactory[] loot) {
        if (loot.length == 0) {
            return b -> EmptyLootEntry.func_216167_a();
        }
        if (loot.length == 1) {
            return loot[0];
        }
        return b -> (LootEntry.Builder)combineFunc.apply(LootFactory.resolve(b, loot));
    }

    public LootEntry.Builder<?> combine(LootEntry.Builder<?> ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new AllLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public LootFactory combine(LootFactory ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new AllLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public LootEntry.Builder<?> random(LootEntry.Builder<?> ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new GroupLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public LootFactory random(LootFactory ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new GroupLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public LootEntry.Builder<?> first(LootEntry.Builder<?> ... loot) {
        return this.combineBy(AlternativesLootEntry::func_216149_a, loot);
    }

    public LootFactory first(LootFactory ... loot) {
        return this.combineBy(AlternativesLootEntry::func_216149_a, loot);
    }

    public LootEntry.Builder<?> whileMatch(LootEntry.Builder<?> ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new SequenceLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public LootFactory whileMatch(LootFactory ... loot) {
        return this.combineBy((LootEntry.Builder<?>[] x$0) -> new SequenceLootBuilder((LootEntry.Builder[])x$0), loot);
    }

    public WrappedLootEntry stack(IItemProvider item) {
        return new WrappedLootEntry(ItemLootEntry.func_216168_a((IItemProvider)item));
    }

    public MatchToolBuilder matchTool(IItemProvider item) {
        return new MatchToolBuilder(ItemPredicate.Builder.func_200309_a().func_200308_a(item));
    }

    public MatchToolBuilder matchTool(ITag<Item> item) {
        return new MatchToolBuilder(ItemPredicate.Builder.func_200309_a().func_200307_a(item));
    }

    public ILootCondition.IBuilder silkCondition() {
        ItemPredicate.Builder predicate = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        return MatchTool.func_216012_a((ItemPredicate.Builder)predicate);
    }

    public WrappedLootEntry stack(ItemStack stack) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)stack.func_77973_b());
        if (stack.func_190916_E() != 1) {
            entry.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)stack.func_190916_E())));
        }
        if (stack.func_77952_i() != 0) {
            float damage = (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k();
            entry.func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)new RandomValueRange(damage)));
        }
        if (stack.func_77942_o()) {
            entry.func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)stack.func_196082_o()));
        }
        return new WrappedLootEntry(entry);
    }

    @Nullable
    protected LootTable.Builder defaultBehavior(Block b) {
        if (b.func_176194_O().func_177619_a().stream().anyMatch(this::needsLootTable)) {
            StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
            LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
            return LootTable.func_216119_b().func_216040_a(pool);
        }
        return null;
    }

    protected boolean needsLootTable(BlockState state) {
        return !state.func_196958_f() && state.func_204520_s().func_206883_i().func_177230_c() != state.func_177230_c() && !LootTables.field_186419_a.equals((Object)state.func_177230_c().func_220068_i());
    }

    public static class MatchToolBuilder
    implements ILootCondition.IBuilder {
        private final ItemPredicate.Builder builder;

        private MatchToolBuilder(ItemPredicate.Builder builder) {
            this.builder = builder;
        }

        @Nonnull
        public ILootCondition build() {
            return MatchTool.func_216012_a((ItemPredicate.Builder)this.builder).build();
        }

        public MatchToolBuilder ench(Enchantment ench) {
            return this.ench(ench, MinMaxBounds.IntBound.func_211340_b((int)1));
        }

        public MatchToolBuilder ench(Enchantment ench, int minLevel) {
            return this.ench(ench, MinMaxBounds.IntBound.func_211340_b((int)minLevel));
        }

        public MatchToolBuilder enchExact(Enchantment ench, int level) {
            return this.ench(ench, MinMaxBounds.IntBound.func_211345_a((int)level));
        }

        private MatchToolBuilder ench(Enchantment ench, MinMaxBounds.IntBound bounds) {
            this.builder.func_218003_a(new EnchantmentPredicate(ench, bounds));
            return this;
        }

        public MatchToolBuilder nbt(CompoundNBT nbt) {
            this.builder.func_218002_a(nbt);
            return this;
        }
    }

    public static class SilkModifier {
        @Nullable
        public final GenericLootModifier modifier;

        private SilkModifier(@Nullable GenericLootModifier modifier) {
            this.modifier = modifier;
        }
    }

    @FunctionalInterface
    public static interface LootModifier
    extends GenericLootModifier,
    StandaloneLootFactory {
        public static LootModifier identity() {
            return (b, e) -> e;
        }

        public static LootModifier chain(LootModifier ... children) {
            if (children.length == 0) {
                return LootModifier.identity();
            }
            if (children.length == 1) {
                return children[0];
            }
            return (b, e) -> {
                StandaloneLootEntry.Builder<?> entry = e;
                for (LootModifier modifier : children) {
                    entry = modifier.apply(b, entry);
                }
                return entry;
            };
        }

        public StandaloneLootEntry.Builder<?> apply(Block var1, StandaloneLootEntry.Builder<?> var2);

        @Override
        default public StandaloneLootEntry.Builder<?> build(Block block) {
            return this.apply(block, StandaloneLootFactory.item().build(block));
        }

        default public LootModifier andThen(LootModifier other) {
            return LootModifier.chain(this, other);
        }
    }

    @FunctionalInterface
    public static interface GenericLootModifier
    extends LootFactory {
        public static GenericLootModifier identity() {
            return (b, e) -> e;
        }

        public LootEntry.Builder<?> apply(Block var1, StandaloneLootEntry.Builder<?> var2);

        @Override
        default public LootEntry.Builder<?> build(Block block) {
            return this.apply(block, StandaloneLootFactory.item().build(block));
        }
    }

    public static class WrappedLootEntry
    implements StandaloneLootFactory {
        public final StandaloneLootEntry.Builder<?> entry;

        private WrappedLootEntry(StandaloneLootEntry.Builder<?> entry) {
            this.entry = entry;
        }

        @Override
        public StandaloneLootEntry.Builder<?> build(Block block) {
            return this.entry;
        }
    }

    @FunctionalInterface
    public static interface StandaloneLootFactory
    extends LootFactory {
        public static StandaloneLootFactory item() {
            return ItemLootEntry::func_216168_a;
        }

        public static StandaloneLootFactory from(StandaloneLootEntry.Builder<?> builder) {
            return b -> builder;
        }

        public static StandaloneLootFactory[] from(StandaloneLootEntry.Builder<?>[] builders) {
            StandaloneLootFactory[] factories = new StandaloneLootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                StandaloneLootEntry.Builder<?> builder = builders[i];
                factories[i] = b -> builder;
            }
            return factories;
        }

        public static StandaloneLootEntry.Builder<?>[] resolve(Block b, StandaloneLootFactory[] factories) {
            StandaloneLootEntry.Builder[] entries = new StandaloneLootEntry.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(b);
            }
            return entries;
        }

        public StandaloneLootEntry.Builder<?> build(Block var1);

        default public LootFactory withFinal(GenericLootModifier finalModifier) {
            return b -> finalModifier.apply(b, this.build(b));
        }

        default public StandaloneLootFactory with(LootModifier ... modifiers) {
            LootModifier chained = LootModifier.chain(modifiers);
            return b -> chained.apply(b, this.build(b));
        }

        @Override
        default public StandaloneLootFactory with(ILootCondition.IBuilder ... conditions) {
            return b -> {
                StandaloneLootEntry.Builder<?> entry = this.build(b);
                for (ILootCondition.IBuilder condition : conditions) {
                    entry.func_212840_b_(condition);
                }
                return entry;
            };
        }

        default public StandaloneLootFactory with(LootFunction.Builder<?> ... functions) {
            LootModifier[] modifiers = new LootModifier[functions.length];
            for (int i = 0; i < functions.length; ++i) {
                LootFunction.Builder<?> function = functions[i];
                modifiers[i] = (b, e) -> e.func_212841_b_((ILootFunction.IBuilder)function);
            }
            LootModifier chained = LootModifier.chain(modifiers);
            return b -> chained.apply(b, this.build(b));
        }
    }

    @FunctionalInterface
    public static interface LootFactory {
        public static LootFactory from(LootEntry.Builder<?> builder) {
            return b -> builder;
        }

        public static LootFactory[] from(LootEntry.Builder<?>[] builders) {
            LootFactory[] factories = new LootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                LootEntry.Builder<?> builder = builders[i];
                factories[i] = b -> builder;
            }
            return factories;
        }

        public static LootEntry.Builder<?>[] resolve(Block b, LootFactory[] factories) {
            LootEntry.Builder[] entries = new LootEntry.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(b);
            }
            return entries;
        }

        public LootEntry.Builder<?> build(Block var1);

        default public LootFactory with(ILootCondition.IBuilder ... conditions) {
            return b -> {
                LootEntry.Builder<?> entry = this.build(b);
                for (ILootCondition.IBuilder condition : conditions) {
                    entry.func_212840_b_(condition);
                }
                return entry;
            };
        }
    }

    public static class SequenceLootBuilder
    extends LootEntry.Builder<SequenceLootBuilder> {
        private final List<LootEntry> lootEntries = new ArrayList<LootEntry>();

        private SequenceLootBuilder(LootEntry.Builder<?> ... entries) {
            for (LootEntry.Builder<?> builder : entries) {
                this.lootEntries.add(builder.func_216081_b());
            }
        }

        @Nonnull
        protected SequenceLootBuilder getSelf() {
            return this;
        }

        public SequenceLootBuilder add(LootEntry.Builder<?> entry) {
            this.lootEntries.add(entry.func_216081_b());
            return this;
        }

        @Nonnull
        public LootEntry func_216081_b() {
            return new SequenceLootEntry(this.lootEntries.toArray(new LootEntry[0]), this.func_216079_f());
        }
    }

    public static class GroupLootBuilder
    extends LootEntry.Builder<GroupLootBuilder> {
        private final List<LootEntry> lootEntries = new ArrayList<LootEntry>();

        private GroupLootBuilder(LootEntry.Builder<?> ... entries) {
            for (LootEntry.Builder<?> builder : entries) {
                this.lootEntries.add(builder.func_216081_b());
            }
        }

        @Nonnull
        protected GroupLootBuilder getSelf() {
            return this;
        }

        public GroupLootBuilder add(LootEntry.Builder<?> entry) {
            this.lootEntries.add(entry.func_216081_b());
            return this;
        }

        @Nonnull
        public LootEntry func_216081_b() {
            return new GroupLootEntry(this.lootEntries.toArray(new LootEntry[0]), this.func_216079_f());
        }
    }

    public static class AllLootBuilder
    extends LootEntry.Builder<AllLootBuilder> {
        private final List<LootEntry> lootEntries = new ArrayList<LootEntry>();

        private AllLootBuilder(LootEntry.Builder<?> ... entries) {
            for (LootEntry.Builder<?> builder : entries) {
                this.lootEntries.add(builder.func_216081_b());
            }
        }

        @Nonnull
        protected AllLootBuilder getSelf() {
            return this;
        }

        public AllLootBuilder add(LootEntry.Builder<?> entry) {
            this.lootEntries.add(entry.func_216081_b());
            return this;
        }

        @Nonnull
        public LootEntry func_216081_b() {
            return new AllLootEntry(this.lootEntries.toArray(new LootEntry[0]), this.func_216079_f());
        }
    }
}

