/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry.market;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryReloadEvent;
import net.blay09.mods.farmingforblockheads.registry.MarketCategory;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.json.ItemStackSerializer;
import net.blay09.mods.farmingforblockheads.registry.json.MarketRegistryDataSerializer;
import net.blay09.mods.farmingforblockheads.registry.market.MarketRegistryData;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="farmingforblockheads")
public class MarketRegistryLoader
implements IResourceManagerReloadListener {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).registerTypeAdapter(MarketRegistryData.class, (Object)new MarketRegistryDataSerializer()).create();
    private static final List<Exception> registryErrors = new ArrayList<Exception>();

    public void func_195410_a(IResourceManager resourceManager) {
        try {
            Throwable throwable;
            MarketRegistry.INSTANCE.reset();
            registryErrors.clear();
            MinecraftForge.EVENT_BUS.post((Event)new MarketRegistryReloadEvent.Pre());
            for (ResourceLocation resourceLocation : resourceManager.func_199003_a("farmingforblockheads_compat", it -> it.endsWith(".json"))) {
                try {
                    IResource resource = resourceManager.func_199002_a(resourceLocation);
                    throwable = null;
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                        this.load((MarketRegistryData)gson.fromJson((Reader)reader, MarketRegistryData.class));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception e) {
                    FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data file at {}", (Object)resourceLocation, (Object)e);
                    registryErrors.add(e);
                }
            }
            File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "farmingforblockheads");
            if (configDir.exists() || configDir.mkdirs()) {
                File configFile = new File(configDir, "MarketRegistry.json");
                if (configFile.exists()) {
                    try {
                        throwable = null;
                        try (FileReader reader = new FileReader(configFile);){
                            this.load((MarketRegistryData)gson.fromJson((Reader)reader, MarketRegistryData.class));
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data from MarketRegistry.json", (Throwable)e);
                        registryErrors.add(e);
                    }
                } else {
                    try {
                        throwable = null;
                        try (FileWriter writer = new FileWriter(configFile);){
                            gson.toJson((Object)new MarketRegistryData(), (Appendable)writer);
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            MarketRegistry.INSTANCE.registerDefaults();
            MinecraftForge.EVENT_BUS.post((Event)new MarketRegistryReloadEvent.Post());
        }
        catch (Exception e) {
            FarmingForBlockheads.logger.error("Exception loading Farming for Blockheads data", (Throwable)e);
            registryErrors.add(e);
        }
    }

    private void load(final @Nullable MarketRegistryData data) {
        if (data == null) {
            return;
        }
        if (data.getModId() != null && !data.getModId().equals("minecraft") && !ModList.get().isLoaded(data.getModId())) {
            return;
        }
        if (data.getGroup() != null) {
            FarmingForBlockheadsAPI.registerMarketDefaultHandler(data.getGroup().getName(), new IMarketRegistryDefaultHandler(){

                @Override
                public void register(@Nullable ItemStack overridePayment, @Nullable Integer overrideCount) {
                    ItemStack effectiveDefaultPayment = data.getGroup().getDefaultPayment();
                    if (effectiveDefaultPayment == null) {
                        effectiveDefaultPayment = this.getDefaultPayment();
                    }
                    if (overridePayment != null) {
                        effectiveDefaultPayment = overridePayment;
                    }
                    MarketRegistryLoader.this.loadMarketData(data, effectiveDefaultPayment, overrideCount);
                }

                @Override
                public boolean isEnabledByDefault() {
                    return data.getGroup().isEnabledByDefault();
                }

                @Override
                public ItemStack getDefaultPayment() {
                    return new ItemStack((IItemProvider)Items.field_151166_bC);
                }
            });
        } else {
            this.loadMarketData(data, new ItemStack((IItemProvider)Items.field_151166_bC), null);
        }
    }

    private void loadMarketData(MarketRegistryData data, ItemStack defaultPayment, @Nullable Integer overrideCount) {
        if (data.getCustomCategories() != null) {
            data.getCustomCategories().forEach((key, categoryData) -> {
                ResourceLocation resourceLocation = new ResourceLocation(key);
                MarketRegistry.INSTANCE.registerCategory(new MarketCategory(resourceLocation, categoryData.getName(), categoryData.getIcon(), categoryData.getSortIndex()));
            });
        }
        if (data.getEntryOverrides() != null) {
            data.getEntryOverrides().forEach(MarketRegistry.INSTANCE::registerEntryOverride);
        }
        if (data.getGroupOverrides() != null) {
            data.getGroupOverrides().forEach(MarketRegistry.INSTANCE::registerGroupOverride);
        }
        if (data.getCustomEntries() != null) {
            data.getCustomEntries().forEach(it -> {
                ResourceLocation categoryKey = it.getCategory();
                if (categoryKey == null) {
                    categoryKey = data.getGroup() != null ? data.getGroup().getDefaultCategory() : new ResourceLocation("farmingforblockheads:other");
                }
                IMarketCategory category = MarketRegistry.getCategory(categoryKey);
                ItemStack effectivePayment = it.getPayment();
                if (effectivePayment == null) {
                    effectivePayment = defaultPayment;
                }
                ItemStack effectiveOutput = it.getOutput();
                if (overrideCount != null) {
                    effectiveOutput = ItemHandlerHelper.copyStackWithSize((ItemStack)effectiveOutput, (int)overrideCount);
                }
                MarketRegistry.INSTANCE.registerEntry(effectiveOutput, effectivePayment, category);
            });
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!registryErrors.isEmpty()) {
            event.getPlayer().func_146105_b((ITextComponent)MarketRegistryLoader.getErrorTextComponent("There were registry errors in the FarmingForBlockheads market data. See the log for full details."), false);
            for (Exception registryError : registryErrors) {
                event.getPlayer().func_146105_b((ITextComponent)MarketRegistryLoader.getErrorTextComponent("- " + registryError.getMessage()), false);
            }
        }
    }

    private static StringTextComponent getErrorTextComponent(String message) {
        StringTextComponent result = new StringTextComponent(message);
        result.func_240699_a_(TextFormatting.RED);
        return result;
    }
}

