/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MarketListMessage {
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap;

    public MarketListMessage(ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap) {
        this.entryMap = entryMap;
    }

    public static MarketListMessage decode(PacketBuffer buf) {
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        int categoryCount = buf.readByte();
        MarketRegistry.resetCategories();
        for (int i = 0; i < categoryCount; ++i) {
            ResourceLocation categoryId = buf.func_192575_l();
            String tooltipLangKey = buf.func_218666_n();
            ItemStack icon = buf.func_150791_c();
            byte sortIndex = buf.readByte();
            IMarketCategory category = FarmingForBlockheadsAPI.registerMarketCategoryAndReturn(categoryId, tooltipLangKey, icon, sortIndex);
            int entryCount = buf.readShort();
            for (int j = 0; j < entryCount; ++j) {
                entryMap.put((Object)category, (Object)MarketListMessage.readEntry(buf, category));
            }
        }
        return new MarketListMessage((ArrayListMultimap<IMarketCategory, IMarketEntry>)entryMap);
    }

    public static void encode(MarketListMessage message, PacketBuffer buf) {
        buf.writeByte(message.entryMap.keySet().size());
        for (IMarketCategory category : message.entryMap.keySet()) {
            buf.func_192572_a(category.getRegistryName());
            buf.func_180714_a(category.getTooltipLangKey());
            buf.func_150788_a(category.getIconStack());
            buf.writeByte(category.getSortIndex());
            List entries = message.entryMap.get((Object)category);
            buf.writeShort(entries.size());
            for (IMarketEntry entry : entries) {
                MarketListMessage.writeEntry(entry, buf);
            }
        }
    }

    public static void handle(MarketListMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> FarmingForBlockheads.proxy.receivedMarketList(message.entryMap));
        context.setPacketHandled(true);
    }

    private static MarketEntry readEntry(PacketBuffer buf, IMarketCategory category) {
        UUID entryId = buf.func_179253_g();
        ItemStack outputItem = buf.func_150791_c();
        ItemStack costItem = buf.func_150791_c();
        return new MarketEntry(entryId, outputItem, costItem, category);
    }

    private static void writeEntry(IMarketEntry entry, PacketBuffer buf) {
        buf.func_179252_a(entry.getEntryId());
        buf.func_150788_a(entry.getOutputItem());
        buf.func_150788_a(entry.getCostItem());
    }
}

