/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideBrewingStand
implements ICraftingProcessOverride {
    private static final Direction SIDE_INGREDIENT = Direction.UP;
    private static final Direction SIDE_BOTTLE = Direction.NORTH;

    @Override
    public boolean isApplicable(PartPos target) {
        return this.getTile(target).isPresent();
    }

    @Nullable
    private Optional<BrewingStandTileEntity> getTile(PartPos target) {
        return TileHelpers.getSafeTile((DimPos)target.getPos(), BrewingStandTileEntity.class);
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, ICraftingResultsSink resultsSink, boolean simulate) {
        List instances = ingredients.getInstances(IngredientComponent.ITEMSTACK);
        if (instances.size() != 4 || ingredients.getComponents().size() != 1) {
            return false;
        }
        return this.getTile(targetGetter.apply(IngredientComponent.ITEMSTACK)).map(tile -> {
            IItemHandler ingredientHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, SIDE_INGREDIENT).orElse(null);
            IItemHandler bottleHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, SIDE_BOTTLE).orElse(null);
            if (ingredientHandler != null && bottleHandler != null) {
                int ingredientSlotIndex = 0;
                int bottleSlotIndex = 0;
                for (ItemStack instance : instances) {
                    if (!(BrewingRecipeRegistry.isValidIngredient((ItemStack)instance) ? !ingredientHandler.insertItem(ingredientSlotIndex++, instance, simulate).func_190926_b() : !bottleHandler.insertItem(bottleSlotIndex++, instance, simulate).func_190926_b())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }).orElse(false);
    }
}

