/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.items;

import com.haoict.tiab.Tiab;
import com.haoict.tiab.common.entities.EntityTimeAccelerator;
import com.haoict.tiab.common.utils.PlaySound;
import com.haoict.tiab.config.TiabConfig;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractItemTiab
extends Item {
    private static final int THIRTY_SECONDS = 20 * (Integer)TiabConfig.COMMON.eachUseDuration.get();
    private static final String[] NOTES = new String[]{"C", "D", "E", "F", "G2", "A2", "B2", "C2", "D2", "E2", "F2"};

    public AbstractItemTiab() {
        super(new Item.Properties().func_200916_a(Tiab.TIAB_ITEM_GROUP).func_200917_a(1));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        BlockState blockState = world.func_180495_p(pos);
        TileEntity targetTE = world.func_175625_s(pos);
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (!(blockState.func_204519_t() || targetTE != null && targetTE instanceof ITickableTileEntity)) {
            return ActionResultType.FAIL;
        }
        int nextRate = 1;
        int energyRequired = this.getEnergyCost(nextRate);
        boolean isCreativeMode = player != null && player.field_71075_bZ.field_75098_d;
        Optional o = context.func_195991_k().func_217357_a(EntityTimeAccelerator.class, new AxisAlignedBB(pos).func_186664_h(0.2)).stream().findFirst();
        if (o.isPresent()) {
            EntityTimeAccelerator entityTA = (EntityTimeAccelerator)((Object)o.get());
            int currentRate = entityTA.getTimeRate();
            int usedUpTime = THIRTY_SECONDS - entityTA.getRemainingTime();
            if ((double)currentRate >= Math.pow(2.0, (Integer)TiabConfig.COMMON.maxTimeRatePower.get() - 1)) {
                return ActionResultType.SUCCESS;
            }
            nextRate = currentRate * 2;
            int timeAdded = usedUpTime / 2;
            energyRequired = this.getEnergyCost(nextRate);
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return ActionResultType.SUCCESS;
            }
            entityTA.setTimeRate(nextRate);
            entityTA.setRemainingTime(entityTA.getRemainingTime() + timeAdded);
        } else {
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return ActionResultType.SUCCESS;
            }
            EntityTimeAccelerator entityTA = new EntityTimeAccelerator(context.func_195991_k(), pos, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            entityTA.setRemainingTime(THIRTY_SECONDS);
            world.func_217376_c((Entity)entityTA);
        }
        if (!isCreativeMode) {
            this.applyDamage(stack, energyRequired);
        }
        this.playSound(world, pos, nextRate);
        return ActionResultType.SUCCESS;
    }

    public int getEnergyCost(int timeRate) {
        if (timeRate <= 1) {
            return THIRTY_SECONDS;
        }
        return timeRate / 2 * THIRTY_SECONDS;
    }

    public boolean canUse(ItemStack stack, boolean isCreativeMode, int energyRequired) {
        return this.getStoredEnergy(stack) >= energyRequired || isCreativeMode;
    }

    protected abstract int getStoredEnergy(ItemStack var1);

    protected abstract void setStoredEnergy(ItemStack var1, int var2);

    protected abstract void applyDamage(ItemStack var1, int var2);

    public void playSound(World world, BlockPos pos, int nextRate) {
        switch (nextRate) {
            case 1: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[0]);
                break;
            }
            case 2: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[1]);
                break;
            }
            case 4: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[2]);
                break;
            }
            case 8: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[3]);
                break;
            }
            case 16: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[4]);
                break;
            }
            case 32: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[5]);
                break;
            }
            case 64: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[6]);
                break;
            }
            case 128: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[7]);
                break;
            }
            case 256: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[8]);
                break;
            }
            case 512: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[9]);
                break;
            }
            default: {
                PlaySound.playNoteBlockHarpSound(world, pos, NOTES[10]);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

