/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.entities;

import com.haoict.tiab.common.entities.TiabEntityTypes;
import com.haoict.tiab.config.TiabConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityTimeAccelerator
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> TIME_RATE = EntityDataManager.func_187226_a(EntityTimeAccelerator.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int remainingTime;
    private BlockPos pos;

    public EntityTimeAccelerator(EntityType entityType, World worldIn) {
        super(entityType, worldIn);
        this.field_70145_X = true;
        this.field_70180_af.func_187214_a(TIME_RATE, (Object)1);
    }

    public EntityTimeAccelerator(World worldIn, BlockPos pos, double posX, double posY, double posZ) {
        this(TiabEntityTypes.timeAcceleratorEntityType, worldIn);
        this.pos = pos;
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.pos == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_241204_bJ_();
            }
            return;
        }
        BlockState blockState = this.field_70170_p.func_180495_p(this.pos);
        ServerWorld serverWorld = this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_());
        TileEntity targetTE = this.field_70170_p.func_175625_s(this.pos);
        for (int i = 0; i < this.getTimeRate(); ++i) {
            if (targetTE != null && targetTE instanceof ITickableTileEntity) {
                ((ITickableTileEntity)targetTE).func_73660_a();
                continue;
            }
            if (serverWorld == null || !blockState.func_204519_t() || this.field_70170_p.field_73012_v.nextInt((Integer)TiabConfig.COMMON.averageUpdateRandomTick.get()) != 0) continue;
            blockState.func_227034_b_(serverWorld, this.pos, this.field_70170_p.field_73012_v);
        }
        --this.remainingTime;
        if (this.remainingTime <= 0 && !this.field_70170_p.field_72995_K) {
            this.func_241204_bJ_();
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getTimeRate() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_RATE);
    }

    public void setTimeRate(int timeRate) {
        this.field_70180_af.func_187227_b(TIME_RATE, (Object)timeRate);
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(int remainingTime) {
        this.remainingTime = remainingTime;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }
}

