/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class StandardBlocks {
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_MIPPED = 2L;
    public static final long CFG_TRANSLUCENT = 4L;
    public static final long CFG_WATERLOGGABLE = 8L;
    public static final long CFG_HORIZIONTAL = 16L;
    public static final long CFG_LOOK_PLACEMENT = 32L;
    public static final long CFG_FACING_PLACEMENT = 64L;
    public static final long CFG_OPPOSITE_PLACEMENT = 128L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 256L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 512L;
    public static final long CFG_STRICT_CONNECTIONS = 1024L;
    public static final long CFG_AI_PASSABLE = 2048L;

    public static class HorizontalFourWayWaterLoggable
    extends WaterLoggable
    implements IStandardBlock {
        public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
        public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
        public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
        public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
        protected final Map<BlockState, VoxelShape> shapes;
        protected final Map<BlockState, VoxelShape> collision_shapes;

        public HorizontalFourWayWaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB base_aabb, AxisAlignedBB side_aabb, int railing_height_extension) {
            super(config, properties, base_aabb);
            HashMap<BlockState, VoxelShape> build_shapes = new HashMap<BlockState, VoxelShape>();
            HashMap<BlockState, VoxelShape> build_collision_shapes = new HashMap<BlockState, VoxelShape>();
            for (BlockState state : this.func_176194_O().func_177619_a()) {
                VoxelShape shape;
                VoxelShape voxelShape = shape = base_aabb.func_216364_b() == 0.0 || base_aabb.func_216360_c() == 0.0 || base_aabb.func_216362_d() == 0.0 ? VoxelShapes.func_197880_a() : VoxelShapes.func_197881_a((AxisAlignedBB)base_aabb);
                if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (shape.func_197766_b()) {
                    shape = VoxelShapes.func_197868_b();
                }
                build_shapes.put((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape);
                build_shapes.put((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape);
                VoxelShape voxelShape2 = shape = base_aabb.func_216364_b() == 0.0 || base_aabb.func_216360_c() == 0.0 || base_aabb.func_216362_d() == 0.0 ? VoxelShapes.func_197880_a() : VoxelShapes.func_197881_a((AxisAlignedBB)base_aabb);
                if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.NORTH, true).func_72321_a(0.0, (double)railing_height_extension, 0.0)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.EAST, true).func_72321_a(0.0, (double)railing_height_extension, 0.0)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.SOUTH, true).func_72321_a(0.0, (double)railing_height_extension, 0.0)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
                    shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(side_aabb, Direction.WEST, true).func_72321_a(0.0, (double)railing_height_extension, 0.0)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                if (shape.func_197766_b()) {
                    shape = VoxelShapes.func_197868_b();
                }
                build_collision_shapes.put((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), shape);
                build_collision_shapes.put((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), shape);
            }
            this.shapes = build_shapes;
            this.collision_shapes = build_collision_shapes;
            this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return this.shapes.getOrDefault(state, VoxelShapes.func_197868_b());
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return this.collision_shapes.getOrDefault(state, VoxelShapes.func_197868_b());
        }

        public static BooleanProperty getDirectionProperty(Direction face) {
            switch (face) {
                case EAST: {
                    return EAST;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return NORTH;
        }
    }

    public static class HorizontalWaterLoggable
    extends Horizontal
    implements IWaterLoggable,
    IStandardBlock {
        public HorizontalWaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L | 0x10L, properties, aabb);
        }

        public HorizontalWaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L | 0x10L, properties, aabbs);
        }

        public HorizontalWaterLoggable(long config, AbstractBlock.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L | 0x10L, properties, shape_supplier);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }
    }

    public static class DirectedWaterLoggable
    extends Directed
    implements IWaterLoggable,
    IStandardBlock {
        public DirectedWaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L, properties, aabb);
        }

        public DirectedWaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        public DirectedWaterLoggable(long config, AbstractBlock.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 8L, properties, shape_supplier);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }
    }

    public static class Horizontal
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
        protected final ArrayList<VoxelShape> vshapes;

        public Horizontal(long config, AbstractBlock.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config | 0x10L, properties);
            this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
            this.vshapes = shape_supplier.get();
        }

        public Horizontal(long config, AbstractBlock.Properties properties, AxisAlignedBB[] unrotatedAABBs) {
            this(config, properties, () -> Horizontal.makeHorizontalShapeLookup(unrotatedAABBs));
        }

        public Horizontal(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedAABB) {
            this(config, properties, new AxisAlignedBB[]{unrotatedAABB});
        }

        protected static ArrayList<VoxelShape> makeHorizontalShapeLookup(AxisAlignedBB[] unrotatedAABBs) {
            return new ArrayList<VoxelShape>(Arrays.asList(VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, true)), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()));
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshapes.get(((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176745_a() & 7);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.func_220053_a(state, world, pos, selectionContext);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{HORIZONTAL_FACING});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            Direction facing = context.func_196000_l();
            if ((this.config & 0x20L) != 0L) {
                facing = context.func_195992_f();
            } else {
                Direction direction = facing = facing == Direction.UP || facing == Direction.DOWN ? context.func_195992_f() : facing;
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.func_176734_d();
            }
            if ((this.config & 0x200L) != 0L && context.func_195999_j().func_225608_bj_()) {
                facing = facing.func_176734_d();
            }
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)facing);
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
        }
    }

    public static class Directed
    extends Cutout
    implements IStandardBlock {
        public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
        protected final ArrayList<VoxelShape> vshapes;

        public Directed(long config, AbstractBlock.Properties properties, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, properties);
            this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP));
            this.vshapes = shape_supplier.get();
        }

        public Directed(long config, AbstractBlock.Properties properties, AxisAlignedBB[] unrotatedAABBs) {
            this(config, properties, () -> {
                boolean is_horizontal = (config & 0x10L) != 0L;
                return new ArrayList<VoxelShape>(Arrays.asList(Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.DOWN, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.UP, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.NORTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.SOUTH, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.WEST, is_horizontal)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(unrotatedAABBs, Direction.EAST, is_horizontal)), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()));
            });
        }

        public Directed(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedAABB) {
            this(config, properties, new AxisAlignedBB[]{unrotatedAABB});
        }

        @Override
        public boolean func_181623_g() {
            return false;
        }

        public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
            return false;
        }

        @Override
        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshapes.get(((Direction)state.func_177229_b((Property)FACING)).func_176745_a() & 7);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.func_220053_a(state, world, pos, selectionContext);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{FACING});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            Direction facing = context.func_196000_l();
            if ((this.config & 0x30L) == 48L) {
                facing = context.func_195992_f();
            } else if ((this.config & 0x30L) == 16L) {
                if (facing == Direction.UP || facing == Direction.DOWN) {
                    return null;
                }
            } else if ((this.config & 0x20L) != 0L) {
                facing = context.func_196010_d();
            }
            if ((this.config & 0x80L) != 0L) {
                facing = facing.func_176734_d();
            }
            if ((this.config & 0x200L) != 0L && context.func_195999_j().func_225608_bj_()) {
                facing = facing.func_176734_d();
            }
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)facing);
        }
    }

    public static class WaterLoggable
    extends Cutout
    implements IWaterLoggable,
    IStandardBlock {
        public WaterLoggable(long config, AbstractBlock.Properties properties) {
            super(config | 8L, properties);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            super(config | 8L, properties, aabb);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, VoxelShape voxel_shape) {
            super(config | 8L, properties, voxel_shape);
        }

        public WaterLoggable(long config, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            super(config | 8L, properties, aabbs);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{WATERLOGGED});
        }
    }

    public static class Cutout
    extends BaseBlock
    implements IStandardBlock {
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
        private final VoxelShape vshape;

        public Cutout(long conf, AbstractBlock.Properties properties) {
            this(conf, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        }

        public Cutout(long conf, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
            this(conf, properties, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
        }

        public Cutout(long conf, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
            this(conf, properties, Arrays.stream(aabbs).map(aabb -> VoxelShapes.func_197881_a((AxisAlignedBB)aabb)).reduce(VoxelShapes.func_197880_a(), (shape, aabb) -> VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)aabb, (IBooleanFunction)IBooleanFunction.field_223244_o_)));
        }

        public Cutout(long conf, AbstractBlock.Properties properties, VoxelShape voxel_shape) {
            super(conf, properties);
            this.vshape = voxel_shape;
            BlockState state = (BlockState)this.func_176194_O().func_177621_b();
            if ((conf & 8L) != 0L) {
                state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.func_180632_j(state);
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshape;
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return this.vshape;
        }

        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if ((this.config & 8L) != 0L) {
                FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
                state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
            }
            return state;
        }

        public boolean func_181623_g() {
            return false;
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.NORMAL;
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                return false;
            }
            return super.func_200123_i(state, reader, pos);
        }

        public FluidState func_204507_t(BlockState state) {
            if ((this.config & 8L) != 0L) {
                return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
            }
            return super.func_204507_t(state);
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if ((this.config & 8L) != 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return state;
        }
    }

    public static class BaseBlock
    extends Block
    implements IStandardBlock {
        public final long config;

        public BaseBlock(long conf, AbstractBlock.Properties properties) {
            super(properties);
            this.config = conf;
            BlockState state = (BlockState)this.func_176194_O().func_177621_b();
            this.func_180632_j(state);
        }

        @Override
        public long config() {
            return this.config;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
        }

        @Override
        public IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config);
        }

        public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
            return (this.config & 0x800L) == 0L ? false : super.func_196266_a(state, world, pos, type);
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
                world.func_175713_t(pos);
                world.func_175666_e(pos, (Block)this);
            }
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            ServerWorld world = builder.func_216018_a();
            Float explosion_radius = (Float)builder.func_216019_b(LootParameters.field_216290_j);
            TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
            if (!this.hasDynamicDropList() || world == null) {
                return super.func_220076_a(state, builder);
            }
            boolean is_explosion = explosion_radius != null && explosion_radius.floatValue() > 0.0f;
            return this.dropList(state, (World)world, te, is_explosion);
        }
    }

    public static interface IBlockItemFactory {
        public BlockItem getBlockItem(Block var1, Item.Properties var2);
    }

    public static interface IStandardBlock {
        default public long config() {
            return 0L;
        }

        default public boolean hasDynamicDropList() {
            return false;
        }

        default public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
            return Collections.singletonList(!world.func_201670_d() ? new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()) : ItemStack.field_190927_a);
        }

        default public RenderTypeHint getRenderTypeHint() {
            return this.getRenderTypeHint(this.config());
        }

        default public RenderTypeHint getRenderTypeHint(long config) {
            if ((config & 1L) != 0L) {
                return RenderTypeHint.CUTOUT;
            }
            if ((config & 2L) != 0L) {
                return RenderTypeHint.CUTOUT_MIPPED;
            }
            if ((config & 4L) != 0L) {
                return RenderTypeHint.TRANSLUCENT;
            }
            return RenderTypeHint.SOLID;
        }

        public static enum RenderTypeHint {
            SOLID,
            CUTOUT,
            CUTOUT_MIPPED,
            TRANSLUCENT,
            TRANSLUCENT_NO_CRUMBLING;

        }
    }
}

