/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tfar.craftingstation.CraftingStationContainer;
import com.tfar.craftingstation.client.ClearButton;
import com.tfar.craftingstation.client.TabButton;
import com.tfar.craftingstation.network.C2SClearPacket;
import com.tfar.craftingstation.network.PacketHandler;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;

public class CraftingStationScreen
extends ContainerScreen<CraftingStationContainer> {
    public static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    public static final ResourceLocation SCROLLBAR_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = new ResourceLocation("craftingstation", "textures/gui/secondary.png");
    private double currentScroll;
    private boolean isScrolling = false;
    private int topRow = 0;

    public CraftingStationScreen(CraftingStationContainer p_i51094_1_, PlayerInventory p_i51094_2_, ITextComponent p_i51094_3_) {
        super((Container)p_i51094_1_, p_i51094_2_, p_i51094_3_);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            for (int i2 = 0; i2 < ((CraftingStationContainer)this.field_147002_h).containerStarts.size(); ++i2) {
                this.func_230480_a_((Widget)new TabButton(this.field_147003_i - 120 + 20 * i2, this.field_147009_r - 22, 22, 22, button -> this.changeContainer(((TabButton)button).index), i2, ((CraftingStationContainer)this.field_147002_h).blocks.get(i2)));
            }
        }
        if (!ModList.get().isLoaded("craftingtweaks")) {
            Button.ITooltip tooltip = (button, matrices, i, i1) -> this.func_238654_b_(matrices, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("text.crafting_station.clear"), Math.max(this.field_230708_k_ / 2 - 43, 170)), i, i1);
            this.func_230480_a_((Widget)new ClearButton(this.field_147003_i + 85, this.field_147009_r + 16, 7, 7, b -> PacketHandler.INSTANCE.sendToServer((Object)new C2SClearPacket()), tooltip));
        }
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean b = super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && (!((CraftingStationContainer)this.field_147002_h).hasSideContainers || !this.func_195359_a(-126, -16, 126, 32 + this.field_147000_g, mouseX, mouseY));
        return b;
    }

    public void changeContainer(int container) {
        ((CraftingStationContainer)this.field_147002_h).changeContainer(container);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack stack, int p_146979_1_, int p_146979_2_) {
        super.func_230451_b_(stack, p_146979_1_, p_146979_2_);
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            this.field_230712_o_.func_238421_b_(stack, ((CraftingStationContainer)this.field_147002_h).containerNames.get(((CraftingStationContainer)this.field_147002_h).currentContainer).getString(), -120.0f, 6.0f, 0x404040);
        }
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        this.func_238474_b_(stack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = this.field_147003_i;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainers) {
            this.field_230706_i_.func_110434_K().func_110577_a(SECONDARY_GUI_TEXTURE);
            this.func_238474_b_(stack, i - 130, j, 0, 0, this.field_146999_f, this.field_147000_g + 18);
            this.field_230706_i_.func_110434_K().func_110577_a(SCROLLBAR_BACKGROUND_AND_TAB);
            int totalSlots = ((CraftingStationContainer)this.field_147002_h).getSlotCount();
            int slotsToDraw = 54;
            if (totalSlots < slotsToDraw) {
                slotsToDraw = totalSlots;
            } else if (this.hasScrollbar() && this.topRow == ((CraftingStationContainer)this.field_147002_h).getRows() - 9 && totalSlots % 6 != 0) {
                slotsToDraw = 48 + totalSlots % 6;
            }
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                this.func_238474_b_(stack, i + j1 * 18 + offset, 18 * k1 + j + 16, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                this.func_238474_b_(stack, i - 17, j + 16, 174, 17, 14, 100);
                this.func_238474_b_(stack, i - 17, j + 67, 174, 18, 14, 111);
                this.field_230706_i_.func_110434_K().func_110577_a(SCROLLBAR_AND_TAB);
                int k = (int)((double)(j + 17) + 145.0 * this.currentScroll);
                if (this.isScrolling && mouseX <= i2 && mouseX >= i1) {
                    this.func_238474_b_(stack, i - 16, k, 244, 0, 12, 15);
                } else {
                    this.func_238474_b_(stack, i - 16, k, 232, 0, 12, 15);
                }
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = this.hasScrollbar();
        return super.func_231044_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int j = this.field_147009_r;
            int j1 = j + 24;
            int j2 = j1 + 145;
            int k = this.field_147003_i;
            int k1 = k - 16;
            int k2 = k1 + 14;
            if (mouseX <= (double)k2 && mouseX >= (double)k1) {
                this.currentScroll = (mouseY - (double)j1) / (double)((float)(j2 - j1) - 0.0f);
                this.currentScroll = MathHelper.func_151237_a((double)this.currentScroll, (double)0.0, (double)1.0);
                this.scrollTo(this.currentScroll);
            }
        }
        return super.func_231045_a_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = false;
        return super.func_231048_c_(mouseX, mouseY, scroll);
    }

    private boolean hasScrollbar() {
        return ((CraftingStationContainer)this.field_147002_h).getRows() > 9;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        if (this.hasScrollbar() && mouseX < (double)this.field_147003_i && mouseX > (double)(this.field_147003_i - 20)) {
            this.setTopRow((int)((double)this.topRow - scrollDelta), false);
            return true;
        }
        return false;
    }

    private void scrollTo(double scroll) {
        this.setTopRow((int)Math.round((double)(((CraftingStationContainer)this.field_147002_h).getRows() - 9) * scroll), true);
    }

    private void setTopRow(int offset, boolean smooth) {
        this.topRow = offset;
        if (this.topRow < 0) {
            this.topRow = 0;
        } else if (this.topRow > ((CraftingStationContainer)this.field_147002_h).getRows() - 9) {
            this.topRow = ((CraftingStationContainer)this.field_147002_h).getRows() - 9;
        }
        ((CraftingStationContainer)this.field_147002_h).updateSlotPositions(this.topRow);
        if (!smooth) {
            this.currentScroll = (double)this.topRow / (double)(((CraftingStationContainer)this.field_147002_h).getRows() - 9);
        }
    }
}

