/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.tfar.craftingstation.CraftingStationBlockEntity;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class CraftingStationBlock
extends Block
implements IWaterLoggable {
    public static final VoxelShape shape;
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;

    public CraftingStationBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        ((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
        }
        return ActionResultType.SUCCESS;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof CraftingStationBlockEntity ? (INamedContainerProvider)te : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CraftingStationBlockEntity();
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CraftingStationBlockEntity) {
                CraftingStationBlock.dropItems((IItemHandler)((CraftingStationBlockEntity)tileentity).input, worldIn, pos);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(IItemHandler inv, World world, BlockPos pos) {
        IntStream.range(0, inv.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inv).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    @Nonnull
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{WATERLOGGED, FACING});
    }

    @Nonnull
    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        BlockPos lvt_3_1_;
        World lvt_2_1_ = p_196258_1_.func_195991_k();
        boolean lvt_4_1_ = lvt_2_1_.func_204610_c(lvt_3_1_ = p_196258_1_.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)p_196258_1_.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(lvt_4_1_));
    }

    static {
        WATERLOGGED = BlockStateProperties.field_208198_y;
        FACING = HorizontalBlock.field_185512_D;
        VoxelShape[] shapes = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0)};
        shape = VoxelShapes.func_216384_a((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{shapes[1], shapes[2], shapes[3], shapes[4]});
    }
}

