/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.world;

import com.mojang.serialization.Codec;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.tileentity.TieredBeehiveTileEntity;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeNestFeature
extends Feature<NoFeatureConfig> {
    private static final EnumSet<Direction> ALLOWED_DIRECTIONS = EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    private static final RandomCollection<Block> overworldBlocks = new RandomCollection();

    public BeeNestFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private void generateHivePlatform(ISeedReader worldIn, BlockPos hivePos, BlockState platformBlock, Direction direction, Block blockToReplace) {
        if (platformBlock == null) {
            platformBlock = Blocks.field_196626_Q.func_176223_P();
        }
        BlockPos posBlockPos = hivePos.func_177971_a(direction.func_176730_m());
        BlockPos negBlockPos = hivePos.func_177971_a(direction.func_176734_d().func_176730_m());
        if (worldIn.func_180495_p(posBlockPos).func_177230_c().equals(blockToReplace)) {
            worldIn.func_180501_a(posBlockPos, platformBlock, 1);
        }
        if (worldIn.func_180495_p(negBlockPos).func_177230_c().equals(blockToReplace)) {
            worldIn.func_180501_a(negBlockPos, platformBlock, 1);
        }
        worldIn.func_180501_a(hivePos, platformBlock, 1);
    }

    private BlockPos getYPos(ISeedReader worldIn, Random rand, Biome.Category category, BlockPos initPos) {
        BlockPos newPos;
        if (category == Biome.Category.NETHER || worldIn.func_230315_m_().func_236037_d_()) {
            int ceilHeight = worldIn.func_234938_ad_();
            newPos = new BlockPos(initPos.func_177958_n(), MathUtils.nextIntInclusive(32, ceilHeight), initPos.func_177952_p()).func_177970_e(rand.nextInt(15)).func_177965_g(rand.nextInt(15));
            while (worldIn.func_175623_d(newPos.func_177977_b())) {
                newPos = newPos.func_177977_b();
            }
            while (!worldIn.func_175623_d(newPos)) {
                newPos = newPos.func_177984_a();
            }
            if (newPos.func_177956_o() >= ceilHeight) {
                return new BlockPos(0, 0, 0);
            }
            if (worldIn.func_180495_p(newPos.func_177977_b()).func_177230_c().equals(Blocks.field_150353_l) && rand.nextInt(10) != 0) {
                return new BlockPos(0, 0, 0);
            }
        } else {
            int y = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, initPos.func_177958_n(), initPos.func_177952_p());
            newPos = new BlockPos(initPos.func_177958_n(), y, initPos.func_177952_p());
        }
        return newPos;
    }

    private Block selectNest(boolean headsOrTails, Block blockOne, Block blockTwo) {
        return headsOrTails ? blockOne : blockTwo;
    }

    private Block getNetherNest(boolean headsOrTails, @Nullable RegistryKey<Biome> biomeKey) {
        if (Biomes.field_235250_aA_.equals(biomeKey)) {
            return this.selectNest(headsOrTails, (Block)ModBlocks.WARPED_BEE_NEST.get(), (Block)ModBlocks.WARPED_NYLIUM_BEE_NEST.get());
        }
        if (Biomes.field_235253_az_.equals(biomeKey)) {
            return this.selectNest(headsOrTails, (Block)ModBlocks.CRIMSON_BEE_NEST.get(), (Block)ModBlocks.CRIMSON_NYLIUM_BEE_NEST.get());
        }
        return this.selectNest(headsOrTails, (Block)ModBlocks.NETHER_BEE_NEST.get(), (Block)ModBlocks.WITHER_BEE_NEST.get());
    }

    private boolean isFrozenBiome(@Nullable RegistryKey<Biome> biomeKey) {
        return biomeKey != null && (biomeKey.equals((Object)Biomes.field_76776_l) || biomeKey.equals((Object)Biomes.field_76777_m) || biomeKey.equals((Object)Biomes.field_203620_Z));
    }

    private void logMissingBiome(RegistryKey<Biome> biomeKey) {
        if (biomeKey != null && ((Boolean)Config.SHOW_DEBUG_INFO.get()).booleanValue()) {
            ResourcefulBees.LOGGER.warn("*****************************************************");
            ResourcefulBees.LOGGER.warn("Could not load bees into nest during chunk generation");
            ResourcefulBees.LOGGER.warn("Biome: {}", (Object)biomeKey.func_240901_a_());
            ResourcefulBees.LOGGER.warn("*****************************************************");
        }
    }

    private void addBeeToNest(@Nullable EntityType<?> entityType, ISeedReader worldIn, BlockPos nestPos, CustomBeeData data, Random rand, TieredBeehiveTileEntity nest) {
        Entity bee;
        if (entityType != null && (bee = entityType.func_200721_a((World)worldIn.func_201672_e())) != null) {
            bee.func_70107_b((double)nestPos.func_177958_n(), (double)nestPos.func_177956_o(), (double)nestPos.func_177952_p());
            CompoundNBT compoundNBT = new CompoundNBT();
            bee.func_70039_c(compoundNBT);
            int timeInHive = rand.nextInt(data.getMaxTimeInHive());
            BeehiveTileEntity.Bee beehiveTileEntityBee = new BeehiveTileEntity.Bee(compoundNBT, 0, timeInHive);
            nest.field_226958_a_.add(beehiveTileEntityBee);
        }
    }

    private void setNestBees(BlockPos nestPos, @Nullable RegistryKey<Biome> biomeKey, ISeedReader worldIn, Random rand) {
        TileEntity tileEntity = worldIn.func_175625_s(nestPos);
        if (tileEntity instanceof TieredBeehiveTileEntity) {
            TieredBeehiveTileEntity nestTE = (TieredBeehiveTileEntity)tileEntity;
            int maxBees = Math.round((float)((Integer)Config.HIVE_MAX_BEES.get()).intValue() * 0.5f);
            for (int i = rand.nextInt(maxBees); i < maxBees; ++i) {
                if (biomeKey != null && BeeRegistry.getSpawnableBiomes().containsKey(biomeKey.func_240901_a_())) {
                    CustomBeeData beeData = BeeRegistry.getSpawnableBiomes().get(biomeKey.func_240901_a_()).next();
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(beeData.getEntityTypeRegistryID());
                    this.addBeeToNest(entityType, worldIn, nestPos, beeData, rand, nestTE);
                    continue;
                }
                this.logMissingBiome(biomeKey);
            }
        }
    }

    public boolean place(@NotNull ISeedReader worldIn, @NotNull ChunkGenerator generator, @NotNull Random rand, @NotNull BlockPos pos, @NotNull NoFeatureConfig config) {
        Block nest;
        if (!((Boolean)Config.GENERATE_BEE_NESTS.get()).booleanValue()) {
            return false;
        }
        Biome biome = worldIn.func_226691_t_(pos);
        Optional biomeKey = worldIn.func_242406_i(pos);
        Biome.Category category = biome.func_201856_r();
        boolean headsOrTails = rand.nextBoolean();
        BlockPos newPos = this.getYPos(worldIn, rand, category, pos);
        if (newPos.func_177956_o() == 0) {
            return false;
        }
        BlockPos.Mutable finalNewPos = newPos.func_239590_i_();
        List possibleDirections = ALLOWED_DIRECTIONS.stream().filter(arg_0 -> BeeNestFeature.lambda$place$0(worldIn, (BlockPos)finalNewPos, arg_0)).collect(Collectors.toList());
        if (possibleDirections.isEmpty()) {
            return false;
        }
        Direction direction = (Direction)possibleDirections.get(rand.nextInt(possibleDirections.size()));
        BlockState platformBlockState = null;
        switch (category) {
            case THEEND: {
                nest = (Block)ModBlocks.PURPUR_BEE_NEST.get();
                break;
            }
            case NETHER: {
                nest = this.getNetherNest(headsOrTails, (RegistryKey<Biome>)((RegistryKey)biomeKey.orElse(null)));
                platformBlockState = Blocks.field_150343_Z.func_176223_P();
                break;
            }
            case SAVANNA: 
            case DESERT: 
            case MESA: {
                nest = (Block)ModBlocks.ACACIA_BEE_NEST.get();
                break;
            }
            case JUNGLE: {
                nest = (Block)ModBlocks.JUNGLE_BEE_NEST.get();
                break;
            }
            case BEACH: 
            case OCEAN: {
                nest = (Block)ModBlocks.PRISMARINE_BEE_NEST.get();
                platformBlockState = this.isFrozenBiome((RegistryKey<Biome>)((RegistryKey)biomeKey.orElse(null))) ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_209389_ab.func_176223_P();
                break;
            }
            case ICY: 
            case TAIGA: {
                platformBlockState = Blocks.field_150403_cj.func_176223_P();
                nest = (Block)ModBlocks.SPRUCE_BEE_NEST.get();
                break;
            }
            case MUSHROOM: {
                nest = this.selectNest(headsOrTails, (Block)ModBlocks.RED_MUSHROOM_BEE_NEST.get(), (Block)ModBlocks.BROWN_MUSHROOM_BEE_NEST.get());
                break;
            }
            case SWAMP: {
                nest = (Block)ModBlocks.OAK_BEE_NEST.get();
                platformBlockState = Blocks.field_209390_ac.func_176223_P();
                break;
            }
            case FOREST: {
                nest = this.selectNest(headsOrTails, (Block)ModBlocks.BIRCH_BEE_NEST.get(), (Block)ModBlocks.DARK_OAK_BEE_NEST.get());
                break;
            }
            case RIVER: {
                platformBlockState = this.isFrozenBiome((RegistryKey<Biome>)((RegistryKey)biomeKey.orElse(null))) ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_196626_Q.func_176223_P();
                nest = overworldBlocks.next();
                break;
            }
            default: {
                platformBlockState = Blocks.field_196626_Q.func_176223_P();
                nest = overworldBlocks.next();
            }
        }
        BlockState newState = (BlockState)nest.func_176223_P().func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)direction);
        BlockPos belowHive = newPos.func_177982_a(0, -1, 0);
        if (worldIn.func_180495_p(belowHive).func_177230_c().equals(Blocks.field_150355_j)) {
            this.generateHivePlatform(worldIn, belowHive, platformBlockState, direction, Blocks.field_150355_j);
        }
        if (category.equals((Object)Biome.Category.NETHER) && worldIn.func_180495_p(belowHive).func_177230_c().equals(Blocks.field_150353_l)) {
            this.generateHivePlatform(worldIn, belowHive, platformBlockState, direction, Blocks.field_150353_l);
        }
        worldIn.func_180501_a(newPos, newState, 1);
        this.setNestBees(newPos, (RegistryKey<Biome>)((RegistryKey)biomeKey.orElse(null)), worldIn, rand);
        return true;
    }

    private static /* synthetic */ boolean lambda$place$0(ISeedReader worldIn, BlockPos finalNewPos, Direction dir) {
        return worldIn.func_175623_d(finalNewPos.func_177967_a(dir, 1));
    }

    static {
        overworldBlocks.add(10.0, (Block)ModBlocks.GRASS_BEE_NEST.get());
        overworldBlocks.add(10.0, (Block)ModBlocks.OAK_BEE_NEST.get());
        overworldBlocks.add(7.0, (Block)ModBlocks.DARK_OAK_BEE_NEST.get());
        overworldBlocks.add(7.0, (Block)ModBlocks.SPRUCE_BEE_NEST.get());
        overworldBlocks.add(5.0, (Block)ModBlocks.BIRCH_BEE_NEST.get());
        overworldBlocks.add(3.0, (Block)ModBlocks.RED_MUSHROOM_BEE_NEST.get());
        overworldBlocks.add(3.0, (Block)ModBlocks.BROWN_MUSHROOM_BEE_NEST.get());
    }
}

