/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils.validation;

import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.Mutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.MutationOutput;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyEffect;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecondPhaseValidator {
    public static final Logger LOGGER = LogManager.getLogger();

    private SecondPhaseValidator() {
        throw new IllegalStateException("Utility Class");
    }

    public static void validateHoneyEffects(HoneyBottleData honeyData) {
        LOGGER.info("Validating Honey Effects...");
        List<HoneyEffect> honeyEffects = honeyData.getEffects();
        if (honeyEffects == null || honeyEffects.isEmpty()) {
            return;
        }
        Iterator<HoneyEffect> effectIterator = honeyEffects.iterator();
        while (effectIterator.hasNext()) {
            HoneyEffect honeyEffect = effectIterator.next();
            Effect effect = honeyEffect.getEffect();
            if (effect == null) {
                LOGGER.warn("An effect for: {} could not be properly validated and was removed.", (Object)honeyData.getHoneyBottleRegistryObject().getId());
                effectIterator.remove();
                continue;
            }
            honeyEffect.setEffect(effect);
        }
        honeyData.setEffects(honeyEffects);
    }

    public static void validateCentrifugeOutputs(CustomBeeData bee) {
        Item mainOutput = BeeInfoUtils.getItem(bee.getCentrifugeData().getMainOutput());
        Fluid fluidOutput = BeeInfoUtils.getFluid(bee.getCentrifugeData().getMainOutput());
        Item secondaryOutput = BeeInfoUtils.getItem(bee.getCentrifugeData().getSecondaryOutput());
        Item bottleOutput = BeeInfoUtils.getItem(bee.getCentrifugeData().getBottleOutput());
        bee.getCentrifugeData().setHasCentrifugeOutput((BeeInfoUtils.isValidFluid(fluidOutput) || BeeInfoUtils.isValidItem(mainOutput)) && BeeInfoUtils.isValidItem(secondaryOutput) && BeeInfoUtils.isValidItem(bottleOutput));
    }

    public static boolean validateMutation(String name, Mutation mutation) {
        if (mutation.getType() == null) {
            LOGGER.warn("\"type\" could not be validated for {}'s mutation.", (Object)name);
            return true;
        }
        if (mutation.getInputID() == null) {
            LOGGER.warn("\"inputID\" does not exist for {}'s mutation.", (Object)name);
            return true;
        }
        if (mutation.getOutputs() == null) {
            LOGGER.warn("\"outputs\" does not exist for {}'s mutation.", (Object)name);
            return true;
        }
        mutation.getOutputs().removeIf(SecondPhaseValidator.validateMutationOutputID(name));
        if (mutation.getOutputs().isEmpty()) {
            LOGGER.warn("No valid outputs could be found for {}'s mutation.", (Object)name);
            return true;
        }
        return false;
    }

    private static Predicate<MutationOutput> validateMutationOutputID(String name) {
        return mutationOutput -> {
            if (mutationOutput.getOutputID() == null) {
                LOGGER.warn("an instance of \"outputID\" does not exist for {}'s mutation.", (Object)name);
                return true;
            }
            return false;
        };
    }
}

