/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils.validation;

import com.google.common.base.Splitter;
import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.beedata.BreedData;
import com.resourcefulbees.resourcefulbees.api.beedata.CentrifugeData;
import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import com.resourcefulbees.resourcefulbees.utils.validation.ValidatorUtils;
import java.util.Iterator;

public class FirstPhaseValidator {
    private FirstPhaseValidator() {
        throw new IllegalStateException("Utility Class");
    }

    public static boolean validate(CustomBeeData bee) {
        FirstPhaseValidator.validateColorData(bee.getColorData(), bee.getName());
        FirstPhaseValidator.validateCentrifugeData(bee.getCentrifugeData(), bee.getName());
        FirstPhaseValidator.validateBreeding(bee.getBreedData(), bee.getName());
        FirstPhaseValidator.validateFlower(bee, bee.getName());
        if (bee.getApiaryOutputAmounts() != null) {
            FirstPhaseValidator.validateCustomApiaryOutputAmounts(bee, bee.getName());
        }
        return true;
    }

    public static boolean validate(HoneyBottleData honeyData) {
        FirstPhaseValidator.validateHoneyBottleColor(honeyData, honeyData.getName());
        FirstPhaseValidator.validateEffectValues(honeyData, honeyData.getName());
        return true;
    }

    private static void validateColorData(ColorData colorData, String name) {
        if (colorData != null) {
            if (colorData.hasHoneycombColor()) {
                FirstPhaseValidator.validateColorData(colorData.getHoneycombColor(), name, "Honeycomb");
            }
            if (colorData.hasPrimaryColor()) {
                FirstPhaseValidator.validateColorData(colorData.getHoneycombColor(), name, "Primary");
            }
            if (colorData.hasSecondaryColor()) {
                FirstPhaseValidator.validateColorData(colorData.getHoneycombColor(), name, "Secondary");
            }
            if (colorData.hasGlowColor()) {
                FirstPhaseValidator.validateColorData(colorData.getHoneycombColor(), name, "Glow");
            }
        }
    }

    private static void validateColorData(String color, String name, String colorType) {
        if (!Color.validate(color)) {
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException(String.format("%1$s Color for %2$s: %3$s is not valid!!", colorType, name, color));
        }
    }

    private static void validateHoneyBottleColor(HoneyBottleData honeyBottleData, String name) {
        if (honeyBottleData != null && honeyBottleData.hasHoneyColor()) {
            FirstPhaseValidator.validateColorData(honeyBottleData.getHoneyColor(), name, "Honey Bottle");
        }
    }

    private static void validateCentrifugeData(CentrifugeData centrifugeData, String name) {
        if (centrifugeData != null && centrifugeData.hasCentrifugeOutput()) {
            FirstPhaseValidator.validateCentrifugeData(centrifugeData.getMainOutput(), name, "Main Output");
            FirstPhaseValidator.validateCentrifugeData(centrifugeData.getSecondaryOutput(), name, "Secondary Output");
            FirstPhaseValidator.validateCentrifugeData(centrifugeData.getBottleOutput(), name, "Bottle Output");
            FirstPhaseValidator.validateCentrifugeData(centrifugeData.getFluidOutput(), name, "Fluid Output");
        }
    }

    private static void validateCentrifugeData(String data, String name, String dataType) {
        if (!data.isEmpty() && ValidatorUtils.isInvalidLocation(data)) {
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException(String.format("Centrifuge %1$s: %2$s has invalid syntax!!", dataType, data));
        }
    }

    private static void validateBreeding(BreedData breedData, String name) {
        if (breedData != null && breedData.isBreedable()) {
            FirstPhaseValidator.validateParents(breedData.getParent1(), breedData.getParent2(), name, "1", "2");
            FirstPhaseValidator.validateParents(breedData.getParent2(), breedData.getParent1(), name, "2", "1");
            if (breedData.hasParents()) {
                Iterator parent1 = Splitter.on((String)",").trimResults().split((CharSequence)breedData.getParent1()).iterator();
                Iterator parent2 = Splitter.on((String)",").trimResults().split((CharSequence)breedData.getParent2()).iterator();
                while (parent1.hasNext() && parent2.hasNext()) {
                    String p2;
                    String p1 = (String)parent1.next();
                    if (!p1.equals(p2 = (String)parent2.next())) continue;
                    FirstPhaseValidator.logError(name);
                    throw new IllegalArgumentException(String.format("Parent 1: %1$s and Parent 2: %2$s are the same parents!!", p1, p2));
                }
            }
        }
    }

    private static void validateParents(String p1, String p2, String name, String type1, String type2) {
        if (!p1.isEmpty() && p2.isEmpty()) {
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException(String.format("Parent %1$s is empty while Parent %2$s is not!!", type1, type2));
        }
    }

    private static void validateFlower(CustomBeeData beeData, String name) {
        if (beeData.getFlower() == null) {
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException("Flower is missing!");
        }
        if (!(ValidatorUtils.TAG_RESOURCE_PATTERN.matcher(beeData.getFlower()).matches() || !ValidatorUtils.isInvalidLocation(beeData.getFlower()) || ValidatorUtils.ENTITY_RESOURCE_PATTERN.matcher(beeData.getFlower()).matches() || beeData.getFlower().equals("all") || beeData.getFlower().equals("small") || beeData.getFlower().equals("tall"))) {
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException(String.format("Flower: %1$s has invalid syntax!", beeData.getFlower()));
        }
    }

    private static void validateCustomApiaryOutputAmounts(CustomBeeData beeData, String name) {
        for (int i = 0; i < 4; ++i) {
            if (beeData.getApiaryOutputAmounts()[i] != 0 && beeData.getApiaryOutputAmounts()[i] >= -1) continue;
            FirstPhaseValidator.logError(name);
            throw new IllegalArgumentException(String.format("Custom Apiary output amount at index %2$s is invalid! Value: %1$s", beeData.getApiaryOutputAmounts()[i], i));
        }
    }

    private static void validateEffectValues(HoneyBottleData honeyData, String name) {
        if (honeyData.getEffects() != null && !honeyData.getEffects().isEmpty()) {
            honeyData.getEffects().forEach(honeyEffect -> {
                if (!honeyEffect.isEffectIDValid()) {
                    FirstPhaseValidator.logError(name);
                    throw new IllegalArgumentException(String.format("Custom effect is not valid! Value: %s", honeyEffect.getEffectID()));
                }
            });
        }
    }

    private static void logError(String name) {
        ResourcefulBees.LOGGER.error("{} bee has failed validation!", (Object)name);
    }
}

