/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils.color;

import com.resourcefulbees.resourcefulbees.ResourcefulBees;
import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.block.ColoredHoneyBlock;
import com.resourcefulbees.resourcefulbees.block.HoneycombBlock;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.item.BeeSpawnEggItem;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBottleItem;
import com.resourcefulbees.resourcefulbees.item.CustomHoneyBucketItem;
import com.resourcefulbees.resourcefulbees.item.HoneycombItem;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;

public final class ColorHandler {
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();

    private ColorHandler() {
    }

    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        BEE_REGISTRY.getBees().forEach((s, customBeeData) -> {
            if (customBeeData.hasHoneycomb() && customBeeData.getColorData().hasHoneycombColor() && !customBeeData.hasCustomDrop()) {
                ColorHandler.registerItems(colors, HoneycombItem::getColor, (IItemProvider)customBeeData.getCombRegistryObject().get());
                ColorHandler.registerItems(colors, HoneycombBlock::getItemColor, (IItemProvider)customBeeData.getCombBlockItemRegistryObject().get());
            }
            ColorHandler.registerItems(colors, BeeSpawnEggItem::getColor, (IItemProvider)customBeeData.getSpawnEggItemRegistryObject().get());
        });
        BEE_REGISTRY.getHoneyBottles().forEach((h, honeyData) -> {
            ColorHandler.registerItems(colors, CustomHoneyBottleItem::getColor, (IItemProvider)honeyData.getHoneyBottleRegistryObject().get());
            if (((Boolean)Config.HONEY_GENERATE_BLOCKS.get()).booleanValue() && honeyData.doGenerateHoneyBlock()) {
                ColorHandler.registerItems(colors, ColoredHoneyBlock::getItemColor, (IItemProvider)honeyData.getHoneyBlockItemRegistryObject().get());
            }
            if (((Boolean)Config.HONEY_GENERATE_FLUIDS.get()).booleanValue() && honeyData.doGenerateHoneyFluid()) {
                ColorHandler.registerItems(colors, CustomHoneyBucketItem::getColor, (IItemProvider)honeyData.getHoneyBucketItemRegistryObject().get());
            }
        });
        ColorHandler.registerItems(colors, BeeJar::getColor, (IItemProvider)ModItems.BEE_JAR.get());
    }

    public static void onBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        BEE_REGISTRY.getBees().forEach((s, customBeeData) -> {
            if (customBeeData.hasHoneycomb() && customBeeData.getColorData().hasHoneycombColor() && !customBeeData.hasCustomDrop()) {
                ColorHandler.registerBlocks(colors, HoneycombBlock::getBlockColor, (Block)customBeeData.getCombBlockRegistryObject().get());
            }
        });
        BEE_REGISTRY.getHoneyBottles().forEach((h, honeyData) -> {
            if (((Boolean)Config.HONEY_GENERATE_BLOCKS.get()).booleanValue() && honeyData.doGenerateHoneyBlock()) {
                ColorHandler.registerBlocks(colors, ColoredHoneyBlock::getBlockColor, (Block)honeyData.getHoneyBlockRegistryObject().get());
            }
        });
    }

    private static void registerItems(ItemColors handler, IItemColor itemColor, IItemProvider ... items) {
        try {
            handler.func_199877_a(itemColor, items);
        }
        catch (NullPointerException ex) {
            ResourcefulBees.LOGGER.error("ItemColor Registration Failed", (Throwable)ex);
        }
    }

    private static void registerBlocks(BlockColors handler, IBlockColor blockColor, Block ... blocks) {
        try {
            handler.func_186722_a(blockColor, blocks);
        }
        catch (NullPointerException ex) {
            ResourcefulBees.LOGGER.error("BlockColor Registration Failed", (Throwable)ex);
        }
    }
}

