/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.resourcefulbees.resourcefulbees.utils.CubeModel;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class RenderCuboid {
    public static final RenderCuboid INSTANCE = new RenderCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.func_195900_b(), vector.func_195902_c());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.func_195899_a(), value, vector.func_195902_c());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.func_195899_a(), vector.func_195900_b(), value);
        }
        throw new CustomException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static double getValue(Vector3f vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.func_195899_a();
        }
        if (axis == Direction.Axis.Y) {
            return vector.func_195900_b();
        }
        if (axis == Direction.Axis.Z) {
            return vector.func_195902_c();
        }
        throw new CustomException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public void renderCube(CubeModel cube, MatrixStack matrix, IVertexBuilder buffer, int argb, int light, int overlay) {
        Direction[] directions;
        float red = RenderCuboid.getRed(argb);
        float green = RenderCuboid.getGreen(argb);
        float blue = RenderCuboid.getBlue(argb);
        float alpha = RenderCuboid.getAlpha(argb);
        Vector3f size = cube.getSize();
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)cube.getStart().func_195899_a(), (double)cube.getStart().func_195900_b(), (double)cube.getStart().func_195902_c());
        MatrixStack.Entry lastMatrix = matrix.func_227866_c_();
        Matrix4f matrix4f = lastMatrix.func_227870_a_();
        Matrix3f normal = lastMatrix.func_227872_b_();
        for (Direction direction : directions = Direction.values()) {
            Direction face = direction;
            int ordinal = face.ordinal();
            TextureAtlasSprite sprite = cube.sprites[ordinal];
            if (sprite == null) continue;
            Direction.Axis u = face.func_176740_k() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.func_176740_k() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.func_176743_c() == Direction.AxisDirection.POSITIVE ? (float)RenderCuboid.getValue(size, face.func_176740_k()) : 0.0f;
            face = face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? face : face.func_176734_d();
            Direction opposite = face.func_176734_d();
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94210_h();
            float maxV = sprite.func_94206_g();
            double sizeU = RenderCuboid.getValue(size, u);
            double sizeV = RenderCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light, overlay);
                    this.renderPoint(matrix4f, normal, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light, overlay);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.func_227865_b_();
    }

    private void renderPoint(Matrix4f matrix4f, Matrix3f normal, IVertexBuilder buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light, int overlay) {
        int uArray = minU ? 0 : 1;
        int vArray = minV ? 2 : 3;
        Vector3f vertex = RenderCuboid.withValue(VEC_ZERO, u, xyz[uArray]);
        vertex = RenderCuboid.withValue(vertex, v, xyz[vArray]);
        vertex = RenderCuboid.withValue(vertex, face.func_176740_k(), other);
        Vector3i normalForFace = face.func_176730_m();
        float adjustment = 2.5f;
        Vector3f norm = new Vector3f((float)normalForFace.func_177958_n() + adjustment, (float)normalForFace.func_177956_o() + adjustment, (float)normalForFace.func_177952_p() + adjustment);
        norm.func_229194_d_();
        buffer.func_227888_a_(matrix4f, vertex.func_195899_a(), vertex.func_195900_b(), vertex.func_195902_c()).func_227885_a_(red, green, blue, alpha).func_225583_a_(uv[uArray], uv[vArray]).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c()).func_181675_d();
    }

    private static class CustomException
    extends RuntimeException {
        public CustomException(String message) {
            super(message);
        }
    }
}

