/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import java.util.Random;

public final class MathUtils {
    private static final double DOUBLES_EQUAL_PRECISION = 1.0E-9;
    private static final Random RANDOM = new Random();
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;

    private MathUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static double clamp(double value, double lowerBound, double upperBound) {
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static float clamp(float value, float lowerBound, float upperBound) {
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static int clamp(int value, int lowerBound, int upperBound) {
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static boolean doublesEqual(double a, double b) {
        return MathUtils.doublesEqual(a, b, 1.0E-9);
    }

    public static boolean doublesEqual(double a, double b, double precision) {
        return Math.abs(b - a) < precision;
    }

    public static boolean floatsEqual(float a, float b) {
        return MathUtils.floatsEqual(a, b, 1.0E-9f);
    }

    public static boolean floatsEqual(float a, float b, float precision) {
        return Math.abs(b - a) < precision;
    }

    public static boolean inRangeExclusive(double value, double min, double max) {
        return value < max && value > min;
    }

    public static boolean inRangeExclusive(int value, int min, int max) {
        return value < max && value > min;
    }

    public static boolean inRangeInclusive(double value, double min, double max) {
        return value <= max && value >= min;
    }

    public static boolean inRangeInclusive(int value, int min, int max) {
        return value <= max && value >= min;
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int min(int a, int b, int c, int d) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        if (d < a) {
            a = d;
        }
        return a;
    }

    public static int min(int a, int b, int c, int d, int ... rest) {
        int min = MathUtils.min(a, b, c, d);
        for (int i : rest) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b, int c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b, int c, int d) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        if (d > a) {
            a = d;
        }
        return a;
    }

    public static int max(int a, int b, int c, int d, int ... rest) {
        int max = MathUtils.max(a, b, c, d);
        for (int i : rest) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static double nextGaussian(double mean, double deviation) {
        return deviation * RANDOM.nextGaussian() + mean;
    }

    public static double nextGaussian(Random random, double mean, double deviation) {
        return deviation * random.nextGaussian() + mean;
    }

    public static int nextInt(int bound) {
        return RANDOM.nextInt(bound);
    }

    public static int nextIntInclusive(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static int nextIntInclusive(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return RANDOM.nextDouble() < percent;
    }

    public static boolean tryPercentage(Random random, double percent) {
        return random.nextDouble() < percent;
    }

    public static double nextDouble() {
        return RANDOM.nextDouble();
    }
}

