/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import com.resourcefulbees.resourcefulbees.api.IEntity;
import com.resourcefulbees.resourcefulbees.lib.TagConstants;
import com.resourcefulbees.resourcefulbees.mixin.EntityAccessor;
import com.resourcefulbees.resourcefulbees.mixin.LivingEntityAccessor;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class HoneyFluidUtils {
    private HoneyFluidUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static void breathing(LivingEntity entity) {
        boolean invulnerable = entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a;
        boolean isBee = entity instanceof BeeEntity;
        if (isBee) {
            return;
        }
        if (entity.func_70089_S() && entity.func_208600_a(TagConstants.RESOURCEFUL_HONEY)) {
            if (!(entity.func_70648_aU() || EffectUtils.func_205133_c((LivingEntity)entity) || invulnerable)) {
                entity.func_70050_g(HoneyFluidUtils.decreaseAirSupply(entity.func_70086_ai() - 4, entity, entity.field_70170_p.field_73012_v));
                if (entity.func_70086_ai() == -20) {
                    entity.func_70050_g(0);
                    Vector3d vector3d = entity.func_213322_ci();
                    for (int i = 0; i < 8; ++i) {
                        double d2 = entity.field_70170_p.field_73012_v.nextDouble() - entity.field_70170_p.field_73012_v.nextDouble();
                        double d3 = entity.field_70170_p.field_73012_v.nextDouble() - entity.field_70170_p.field_73012_v.nextDouble();
                        double d4 = entity.field_70170_p.field_73012_v.nextDouble() - entity.field_70170_p.field_73012_v.nextDouble();
                        entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, entity.func_226277_ct_() + d2, entity.func_226278_cu_() + d3, entity.func_226281_cx_() + d4, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                    }
                    entity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            }
            if (!entity.field_70170_p.func_201670_d() && entity.func_184218_aH() && entity.func_184187_bx() != null && !entity.func_184187_bx().canBeRiddenInWater((Entity)entity)) {
                entity.func_184210_p();
            }
        }
    }

    protected static int decreaseAirSupply(int airSupply, LivingEntity entity, Random random) {
        int respiration = EnchantmentHelper.func_185292_c((LivingEntity)entity);
        return respiration > 0 && random.nextInt(respiration + 1) > 0 ? airSupply : airSupply - 1;
    }

    public static void doJump(boolean touchedHoney, LivingEntity entity) {
        double fluidHeight = entity.func_233571_b_((ITag)FluidTags.field_206959_a);
        boolean flag = touchedHoney && fluidHeight > 0.0;
        double jumpThreshold = entity.func_233579_cu_();
        if (flag || !entity.func_233570_aj_() && !(fluidHeight > jumpThreshold)) {
            ((LivingEntityAccessor)entity).callJumpInLiquid(TagConstants.RESOURCEFUL_HONEY);
        }
    }

    public static void doFluidMovement(Entity entity) {
        EntityAccessor accessor = (EntityAccessor)entity;
        IEntity implEntity = (IEntity)entity;
        if (entity.func_184187_bx() instanceof BoatEntity) {
            implEntity.setTouchingHoney(false);
        }
        if (entity.func_210500_b(TagConstants.RESOURCEFUL_HONEY, 0.014)) {
            if (!((IEntity)entity).getTouchedHoney() && !accessor.getFirstTick()) {
                HoneyFluidUtils.makeSplash(entity);
            }
            entity.field_70143_R = 0.0f;
            ((IEntity)entity).setTouchingHoney(true);
            entity.func_70066_B();
        } else {
            ((IEntity)entity).setTouchingHoney(false);
        }
    }

    private static void makeSplash(Entity entity) {
        EntityAccessor accessor = (EntityAccessor)entity;
        Entity boat = entity.func_184207_aI() && entity.func_184179_bs() != null ? entity.func_184179_bs() : entity;
        float f = boat == entity ? 0.2f : 0.9f;
        Vector3d vector3d = entity.func_213322_ci();
        float f1 = MathHelper.func_76133_a((double)(vector3d.field_72450_a * vector3d.field_72450_a * (double)0.2f + vector3d.field_72448_b * vector3d.field_72448_b + vector3d.field_72449_c * vector3d.field_72449_c * (double)0.2f)) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        entity.func_184185_a(SoundEvents.field_226136_eQ_, f1 * 2.0f, 1.0f + (accessor.getRandom().nextFloat() - accessor.getRandom().nextFloat()) * 0.4f);
    }
}

