/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.utils;

import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import org.jetbrains.annotations.Nullable;

public class DamageUtils {
    private DamageUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static DamageSource getDamageSource(String source, @Nullable LivingEntity sourceEntity) {
        switch (source.toLowerCase(Locale.ENGLISH)) {
            case "infire": {
                return DamageSource.field_76372_a;
            }
            case "lightningbolt": {
                return DamageSource.field_180137_b;
            }
            case "onfire": {
                return DamageSource.field_76370_b;
            }
            case "lava": {
                return DamageSource.field_76371_c;
            }
            case "hotfloor": {
                return DamageSource.field_190095_e;
            }
            case "inwall": {
                return DamageSource.field_76368_d;
            }
            case "cramming": {
                return DamageSource.field_191291_g;
            }
            case "drown": {
                return DamageSource.field_76369_e;
            }
            case "starve": {
                return DamageSource.field_76366_f;
            }
            case "cactus": {
                return DamageSource.field_76367_g;
            }
            case "fall": {
                return DamageSource.field_76379_h;
            }
            case "flyintowall": {
                return DamageSource.field_188406_j;
            }
            case "outofworld": {
                return DamageSource.field_76380_i;
            }
            case "magic": {
                return DamageSource.field_76376_m;
            }
            case "wither": {
                return DamageSource.field_82727_n;
            }
            case "anvil": {
                return DamageSource.field_82728_o;
            }
            case "fallingblock": {
                return DamageSource.field_82729_p;
            }
            case "dragonbreath": {
                return DamageSource.field_188407_q;
            }
            case "dryout": {
                return DamageSource.field_205132_u;
            }
            case "sweetberrybush": {
                return DamageSource.field_220302_v;
            }
            case "explosion": {
                return sourceEntity != null ? DamageSource.func_188405_b((LivingEntity)sourceEntity) : DamageSource.field_76377_j;
            }
            case "sting": {
                return sourceEntity != null ? DamageSource.func_226252_a_((LivingEntity)sourceEntity) : DamageSource.field_76377_j;
            }
            case "mobattack": {
                return sourceEntity != null ? DamageSource.func_76358_a((LivingEntity)sourceEntity) : DamageSource.field_76377_j;
            }
            case "thorns": {
                return sourceEntity != null ? DamageSource.func_92087_a((Entity)sourceEntity) : DamageSource.field_76377_j;
            }
        }
        return DamageSource.field_76377_j;
    }

    public static boolean dealDamage(float damage, String source, LivingEntity targetEntity, @Nullable LivingEntity sourceEntity) {
        return targetEntity.func_70097_a(DamageUtils.getDamageSource(source, sourceEntity), damage);
    }
}

