/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary;

import com.resourcefulbees.resourcefulbees.api.IBeeRegistry;
import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.api.beedata.BreedData;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.ApiaryStorageContainer;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.item.UpgradeItem;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.lib.ApiaryTabs;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.IApiaryMultiblock;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiaryStorageTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IApiaryMultiblock {
    public static final int UPGRADE_SLOT = 0;
    private static final IBeeRegistry BEE_REGISTRY = BeeRegistry.getRegistry();
    private BlockPos apiaryPos;
    private ApiaryTileEntity apiary;
    private int numberOfSlots = 9;
    private final AutomationSensitiveItemStackHandler itemStackHandler = new TileStackHandler(110);
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getItemStackHandler);

    public ApiaryStorageTileEntity() {
        super((TileEntityType)ModTileEntityTypes.APIARY_STORAGE_TILE_ENTITY.get());
    }

    @NotNull
    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)ModTileEntityTypes.APIARY_STORAGE_TILE_ENTITY.get();
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.apiary_storage");
    }

    @Nullable
    public Container createMenu(int i, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        if (this.field_145850_b != null) {
            return new ApiaryStorageContainer(i, this.field_145850_b, this.field_174879_c, playerInventory);
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.validateApiaryLink();
        }
    }

    public ApiaryTileEntity getApiary() {
        TileEntity tile;
        if (this.apiaryPos != null && this.field_145850_b != null && (tile = this.field_145850_b.func_175625_s(this.apiaryPos)) instanceof ApiaryTileEntity) {
            return (ApiaryTileEntity)tile;
        }
        return null;
    }

    public boolean validateApiaryLink() {
        this.apiary = this.getApiary();
        if (this.apiary == null || this.apiary.getStoragePos() == null || !this.apiary.getStoragePos().equals((Object)this.func_174877_v()) || !this.apiary.isValidApiary(false)) {
            this.apiaryPos = null;
            return false;
        }
        return true;
    }

    private void updateNumberOfSlots() {
        CompoundNBT data;
        ItemStack upgradeItem;
        int count = 9;
        if (!this.getItemStackHandler().getStackInSlot(0).func_190926_b() && UpgradeItem.isUpgradeItem(upgradeItem = this.getItemStackHandler().getStackInSlot(0)) && (data = UpgradeItem.getUpgradeData(upgradeItem)) != null && data.func_74779_i("UpgradeType").equals("Storage")) {
            count = (int)MathUtils.clamp(data.func_74760_g("NumSlots"), 1.0f, 108.0f);
        }
        this.setNumberOfSlots(count);
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromNBT(nbt);
    }

    public void loadFromNBT(CompoundNBT nbt) {
        CompoundNBT invTag = nbt.func_74775_l("inv");
        this.getItemStackHandler().deserializeNBT(invTag);
        if (nbt.func_74764_b("ApiaryPos")) {
            this.apiaryPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("ApiaryPos"));
        }
        if (nbt.func_74764_b("SlotCount")) {
            this.setNumberOfSlots(nbt.func_74762_e("SlotCount"));
        }
    }

    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        return this.saveToNBT(nbt);
    }

    public CompoundNBT saveToNBT(CompoundNBT nbt) {
        CompoundNBT inv = this.getItemStackHandler().serializeNBT();
        nbt.func_218657_a("inv", (INBT)inv);
        if (this.apiaryPos != null) {
            nbt.func_218657_a("ApiaryPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.apiaryPos));
        }
        if (this.getNumberOfSlots() != 9) {
            nbt.func_74768_a("SlotCount", this.getNumberOfSlots());
        }
        return nbt;
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.apiaryPos != null) {
            nbt.func_218657_a("ApiaryPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.apiaryPos));
        }
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        if (nbt.func_74764_b("ApiaryPos")) {
            this.apiaryPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("ApiaryPos"));
        }
    }

    public void deliverHoneycomb(BeeEntity entity, int apiaryTier) {
        ItemStack itemstack;
        String beeType;
        if (entity instanceof ICustomBee && ((ICustomBee)entity).getBeeData().hasHoneycomb()) {
            beeType = ((ICustomBee)entity).getBeeType();
        } else if (!(entity instanceof ICustomBee)) {
            beeType = "minecraft";
        } else {
            return;
        }
        ItemStack comb = beeType.equals("minecraft") ? new ItemStack((IItemProvider)Items.field_226635_pU_) : ((ICustomBee)entity).getBeeData().getCombStack();
        ItemStack combBlock = beeType.equals("minecraft") ? new ItemStack((IItemProvider)Items.field_226640_pZ_) : ((ICustomBee)entity).getBeeData().getCombBlockItemStack();
        int[] outputAmounts = beeType.equals("minecraft") ? null : BEE_REGISTRY.getBeeData(beeType).getApiaryOutputAmounts();
        ApiaryOutput[] outputTypes = !beeType.equals("minecraft") ? BEE_REGISTRY.getBeeData(beeType).getApiaryOutputsTypes() : BeeInfoUtils.getDefaultApiaryTypes();
        switch (apiaryTier) {
            case 8: {
                itemstack = outputTypes[3] == ApiaryOutput.BLOCK ? combBlock.func_77946_l() : comb.func_77946_l();
                itemstack.func_190920_e(outputAmounts != null && outputAmounts[3] != -1 ? outputAmounts[3] : (Integer)Config.T4_APIARY_QUANTITY.get());
                break;
            }
            case 7: {
                itemstack = outputTypes[2] == ApiaryOutput.BLOCK ? combBlock.func_77946_l() : comb.func_77946_l();
                itemstack.func_190920_e(outputAmounts != null && outputAmounts[2] != -1 ? outputAmounts[2] : (Integer)Config.T3_APIARY_QUANTITY.get());
                break;
            }
            case 6: {
                itemstack = outputTypes[1] == ApiaryOutput.BLOCK ? combBlock.func_77946_l() : comb.func_77946_l();
                itemstack.func_190920_e(outputAmounts != null && outputAmounts[1] != -1 ? outputAmounts[1] : (Integer)Config.T2_APIARY_QUANTITY.get());
                break;
            }
            default: {
                itemstack = outputTypes[0] == ApiaryOutput.BLOCK ? combBlock.func_77946_l() : comb.func_77946_l();
                itemstack.func_190920_e(outputAmounts != null && outputAmounts[0] != -1 ? outputAmounts[0] : (Integer)Config.T1_APIARY_QUANTITY.get());
            }
        }
        this.depositItemStack(itemstack);
    }

    public boolean breedComplete(String p1, String p2) {
        if (this.inventoryHasSpace()) {
            Entity entity;
            CustomBeeData childBeeData = BEE_REGISTRY.getWeightedChild(p1, p2);
            float breedChance = BeeRegistry.getRegistry().getBreedChance(p1, p2, childBeeData);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(childBeeData.getEntityTypeRegistryID());
            BreedData p1BreedData = BEE_REGISTRY.getBeeData(p1).getBreedData();
            BreedData p2BreedData = BEE_REGISTRY.getBeeData(p2).getBreedData();
            Item p1Returnable = p1BreedData.getFeedReturnItem();
            Item p2Returnable = p2BreedData.getFeedReturnItem();
            if (this.field_145850_b != null && entityType != null && (entity = entityType.func_200721_a(this.field_145850_b)) != null) {
                ICustomBee beeEntity = (ICustomBee)entity;
                CompoundNBT nbt = BeeInfoUtils.createJarBeeTag((BeeEntity)beeEntity, "Entity");
                ItemStack beeJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
                ItemStack emptyBeeJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
                beeJar.func_77982_d(nbt);
                BeeJar.renameJar(beeJar, (BeeEntity)beeEntity);
                this.depositItemStack(new ItemStack((IItemProvider)p1Returnable, p1BreedData.getFeedAmount()));
                this.depositItemStack(new ItemStack((IItemProvider)p2Returnable, p2BreedData.getFeedAmount()));
                float nextFloat = this.field_145850_b.field_73012_v.nextFloat();
                if (breedChance >= nextFloat) {
                    return this.depositItemStack(beeJar);
                }
                return this.depositItemStack(emptyBeeJar);
            }
        }
        return false;
    }

    public boolean inventoryHasSpace() {
        for (int i = 1; i <= this.getNumberOfSlots(); ++i) {
            if (!this.getItemStackHandler().getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean depositItemStack(ItemStack itemstack) {
        for (int slotIndex = 1; !itemstack.func_190926_b() && slotIndex <= this.getNumberOfSlots(); ++slotIndex) {
            ItemStack slotStack = this.getItemStackHandler().getStackInSlot(slotIndex);
            int maxStackSize = this.getItemStackHandler().getSlotLimit(slotIndex);
            if (slotStack.func_190926_b()) {
                int count = itemstack.func_190916_E();
                slotStack = itemstack.func_77946_l();
                if (count > maxStackSize) {
                    slotStack.func_190920_e(maxStackSize);
                    itemstack.func_190920_e(count - maxStackSize);
                } else {
                    itemstack.func_190920_e(0);
                }
                this.getItemStackHandler().setStackInSlot(slotIndex, slotStack);
                continue;
            }
            if (!Container.func_195929_a((ItemStack)itemstack, (ItemStack)slotStack)) continue;
            int j = itemstack.func_190916_E() + slotStack.func_190916_E();
            if (j <= maxStackSize) {
                itemstack.func_190920_e(0);
                slotStack.func_190920_e(j);
                this.getItemStackHandler().setStackInSlot(slotIndex, slotStack);
                continue;
            }
            if (slotStack.func_190916_E() >= maxStackSize) continue;
            itemstack.func_190918_g(maxStackSize - slotStack.func_190916_E());
            slotStack.func_190920_e(maxStackSize);
            this.getItemStackHandler().setStackInSlot(slotIndex, slotStack);
        }
        return itemstack.func_190926_b();
    }

    public void rebuildOpenContainers() {
        if (this.field_145850_b != null) {
            float f = 5.0f;
            BlockPos pos = this.field_174879_c;
            for (PlayerEntity playerentity : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - f), (double)((float)pos.func_177956_o() - f), (double)((float)pos.func_177952_p() - f), (double)((float)(pos.func_177958_n() + 1) + f), (double)((float)(pos.func_177956_o() + 1) + f), (double)((float)(pos.func_177952_p() + 1) + f)))) {
                ApiaryStorageContainer openContainer;
                ApiaryStorageTileEntity apiaryStorageTileEntity1;
                if (!(playerentity.field_71070_bA instanceof ApiaryStorageContainer) || (apiaryStorageTileEntity1 = (openContainer = (ApiaryStorageContainer)playerentity.field_71070_bA).getApiaryStorageTileEntity()) != this) continue;
                openContainer.setupSlots(true);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        this.updateNumberOfSlots();
    }

    public BlockPos getApiaryPos() {
        return this.apiaryPos;
    }

    public void setApiaryPos(BlockPos apiaryPos) {
        this.apiaryPos = apiaryPos;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.getLazyOptional().cast() : super.getCapability(cap, side);
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 && stack.func_77973_b() instanceof UpgradeItem;
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot > 0 && slot <= 110;
    }

    @Override
    public void switchTab(ServerPlayerEntity player, ApiaryTabs tab) {
        if (this.field_145850_b != null && this.apiaryPos != null) {
            if (tab == ApiaryTabs.MAIN) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.apiaryPos);
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)this.apiaryPos);
            } else if (tab == ApiaryTabs.BREED) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.apiary.getBreederPos());
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)this.apiary.getBreederPos());
            }
        }
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    @NotNull
    public AutomationSensitiveItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public LazyOptional<IItemHandler> getLazyOptional() {
        return this.lazyOptional;
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        @Override
        public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
            return ApiaryStorageTileEntity.this.getAcceptor();
        }

        @Override
        public AutomationSensitiveItemStackHandler.IRemover getRemover() {
            return ApiaryStorageTileEntity.this.getRemover();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ApiaryStorageTileEntity.this.func_70296_d();
            if (slot == 0) {
                ApiaryStorageTileEntity.this.updateNumberOfSlots();
                ApiaryStorageTileEntity.this.rebuildOpenContainers();
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    }
}

