/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.block.TieredBeehiveBlock;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.mixin.BTEBeeAccessor;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TieredBeehiveTileEntity
extends BeehiveTileEntity {
    protected int tier;
    protected float tierModifier;
    private List<ItemStack> honeycombs = new LinkedList<ItemStack>();
    protected boolean isSmoked = false;
    protected int ticksSmoked = -1;
    protected int ticksSinceBeesFlagged;

    public TieredBeehiveTileEntity() {
    }

    public TieredBeehiveTileEntity(int tier, float tierModifier) {
        this.tier = tier;
        this.tierModifier = tierModifier;
    }

    @NotNull
    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)ModTileEntityTypes.TIERED_BEEHIVE_TILE_ENTITY.get();
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setTierModifier(float tierModifier) {
        this.tierModifier = tierModifier;
    }

    public float getTierModifier() {
        return this.tierModifier;
    }

    public int getMaxCombs() {
        return Math.round((float)((Integer)Config.HIVE_MAX_COMBS.get()).intValue() * this.getTierModifier());
    }

    public int getMaxBees() {
        return Math.round((float)((Integer)Config.HIVE_MAX_BEES.get()).intValue() * this.getTierModifier());
    }

    public void recalculateHoneyLevel() {
        float combsInHive = this.getHoneycombs().size();
        float percentValue = combsInHive / (float)this.getMaxCombs() * 100.0f;
        int newState = (int)MathUtils.clamp((percentValue - percentValue % 20.0f) / 20.0f, 0.0f, 5.0f);
        assert (this.field_145850_b != null);
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(newState)));
    }

    public void smokeHive() {
        this.isSmoked = true;
        this.ticksSmoked = this.ticksSmoked == -1 ? 0 : this.ticksSmoked;
    }

    public int getTicksSmoked() {
        return this.ticksSmoked;
    }

    public boolean func_235651_a_(@NotNull BlockState state, @NotNull BeehiveTileEntity.Bee tileBee, @Nullable List<Entity> entities, @NotNull BeehiveTileEntity.State beehiveState) {
        BlockPos blockpos = this.func_174877_v();
        if (this.shouldStayInHive(beehiveState)) {
            return false;
        }
        CompoundNBT nbt = tileBee.field_226977_a_;
        nbt.func_82580_o("Passengers");
        nbt.func_82580_o("Leash");
        nbt.func_82580_o("UUID");
        Direction direction = (Direction)state.func_177229_b((Property)BeehiveBlock.field_226872_b_);
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (this.field_145850_b == null) {
            return false;
        }
        if (!this.field_145850_b.func_180495_p(blockpos1).func_196952_d((IBlockReader)this.field_145850_b, blockpos1).func_197766_b() && beehiveState != BeehiveTileEntity.State.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)this.field_145850_b, entity1 -> entity1);
        if (entity != null) {
            BeeInfoUtils.setEntityLocationAndAngle(blockpos, direction, entity);
            if (entity instanceof BeeEntity) {
                BeeEntity vanillaBeeEntity = (BeeEntity)entity;
                ItemStack honeycomb = new ItemStack((IItemProvider)Items.field_226635_pU_);
                if (beehiveState == BeehiveTileEntity.State.HONEY_DELIVERED) {
                    vanillaBeeEntity.func_226413_eG_();
                    int i = TieredBeehiveTileEntity.func_226964_a_((BlockState)state);
                    if (i < 5) {
                        if (entity instanceof ICustomBee && ((ICustomBee)entity).getBeeData().hasHoneycomb()) {
                            honeycomb = ((ICustomBee)entity).getBeeData().getCombStack();
                        }
                        if (!honeycomb.func_190926_b()) {
                            this.honeycombs.add(0, honeycomb);
                        }
                        this.recalculateHoneyLevel();
                    }
                }
                BeeInfoUtils.ageBee(((BTEBeeAccessor)tileBee).getTicksInHive(), vanillaBeeEntity);
                if (entities != null) {
                    entities.add(entity);
                }
            }
            BlockPos hivePos = this.func_174877_v();
            this.field_145850_b.func_184148_a(null, (double)hivePos.func_177958_n(), (double)hivePos.func_177956_o(), (double)hivePos.func_177952_p(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return this.field_145850_b.func_217376_c(entity);
        }
        return true;
    }

    public void func_226962_a_(@NotNull Entity bee, boolean hasNectar, int ticksInHive) {
        if (this.field_226958_a_.size() < this.getMaxBees()) {
            bee.func_184226_ay();
            CompoundNBT nbt = new CompoundNBT();
            bee.func_70039_c(nbt);
            if (this.field_145850_b != null && bee instanceof BeeEntity) {
                int maxTimeInHive = this.getMaxTimeInHive(bee instanceof ICustomBee ? ((ICustomBee)bee).getBeeData().getMaxTimeInHive() : 2400);
                this.field_226958_a_.add(new BeehiveTileEntity.Bee(nbt, ticksInHive, hasNectar ? maxTimeInHive : 600));
                BlockPos pos = this.func_174877_v();
                this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                bee.func_70106_y();
            }
        }
    }

    private int getMaxTimeInHive(int timeInput) {
        if (this.tier != 1) {
            if (this.tier == 0) {
                return (int)((double)timeInput * 1.05);
            }
            return (int)((double)timeInput * (1.0 - (double)this.getTier() * 0.05));
        }
        return timeInput;
    }

    public boolean func_226972_k_() {
        assert (this.field_145850_b != null);
        return this.isSmoked || CampfireBlock.func_235474_a_((World)this.field_145850_b, (BlockPos)this.func_174877_v());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.isSmoked) {
                if (MathUtils.inRangeInclusive(this.ticksSmoked, 0, 600)) {
                    ++this.ticksSmoked;
                } else {
                    this.isSmoked = false;
                    this.ticksSmoked = -1;
                }
            }
            ++this.ticksSinceBeesFlagged;
            if (this.ticksSinceBeesFlagged == 80) {
                BeeInfoUtils.flagBeesInRange(this.field_174879_c, this.field_145850_b);
                this.ticksSinceBeesFlagged = 0;
            }
        }
        super.func_73660_a();
    }

    public boolean shouldStayInHive(BeehiveTileEntity.State beehiveState) {
        return this.field_145850_b != null && (this.field_145850_b.func_226690_K_() || this.field_145850_b.func_72896_J()) && beehiveState != BeehiveTileEntity.State.EMERGENCY;
    }

    public boolean func_226970_h_() {
        return this.field_226958_a_.size() >= this.getMaxBees();
    }

    public boolean hasBees() {
        return !this.field_226958_a_.isEmpty();
    }

    public ItemStack getResourceHoneycomb() {
        return this.honeycombs.remove(0);
    }

    public boolean hasCombs() {
        return this.numberOfCombs() > 0;
    }

    public int numberOfCombs() {
        return this.getHoneycombs().size();
    }

    public boolean isAllowedBee() {
        Block hive = this.func_195044_w().func_177230_c();
        return hive instanceof TieredBeehiveBlock;
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("Honeycombs")) {
            this.honeycombs = this.getHoneycombs(nbt);
        }
        if (nbt.func_74764_b("Smoked")) {
            this.isSmoked = nbt.func_74767_n("Smoked");
        }
        if (nbt.func_74764_b("Tier")) {
            this.setTier(nbt.func_74762_e("Tier"));
        }
        if (nbt.func_74764_b("TierModifier")) {
            this.setTierModifier(nbt.func_74760_g("TierModifier"));
        }
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.getHoneycombs().isEmpty()) {
            nbt.func_218657_a("Honeycombs", (INBT)this.writeHoneycombs());
        }
        nbt.func_74757_a("Smoked", this.isSmoked);
        nbt.func_74768_a("Tier", this.getTier());
        nbt.func_74776_a("TierModifier", this.getTierModifier());
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return super.func_189518_D_();
    }

    public ListNBT writeHoneycombs() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.numberOfCombs(); ++i) {
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a(String.valueOf(i), i);
            this.getHoneycombs().get(i).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        return nbtTagList;
    }

    public List<ItemStack> getHoneycombs(CompoundNBT nbt) {
        LinkedList<ItemStack> itemStacks = new LinkedList<ItemStack>();
        ListNBT tagList = nbt.func_150295_c("Honeycombs", 10);
        tagList.forEach(compound -> itemStacks.add(0, ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound))));
        return itemStacks;
    }

    public List<ItemStack> getHoneycombs() {
        return Collections.unmodifiableList(this.honeycombs);
    }
}

