/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.block.MechanicalCentrifugeBlock;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.MechanicalCentrifugeContainer;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalCentrifugeTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int HONEYCOMB_SLOT = 0;
    public static final int BOTTLE_SLOT = 1;
    public static final int HONEY_BOTTLE = 2;
    public static final int OUTPUT1 = 3;
    public static final int OUTPUT2 = 4;
    private final AutomationSensitiveItemStackHandler itemStackHandler = new TileStackHandler(5, this.getAcceptor(), this.getRemover());
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getItemStackHandler);
    private final LazyOptional<IItemHandler> automationHandler = LazyOptional.of(() -> new AutomationSensitiveItemStackHandler(5, AutomationSensitiveItemStackHandler.ACCEPT_FALSE, AutomationSensitiveItemStackHandler.REMOVE_FALSE));
    private int clicks;
    private CentrifugeRecipe recipe;
    private ItemStack failedMatch = ItemStack.field_190927_a;

    public MechanicalCentrifugeTileEntity() {
        super((TileEntityType)ModTileEntityTypes.MECHANICAL_CENTRIFUGE_ENTITY.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean dirty = false;
            CentrifugeRecipe irecipe = this.getRecipe();
            if (!this.getItemStackHandler().getStackInSlot(0).func_190926_b() && !this.getItemStackHandler().getStackInSlot(1).func_190926_b()) {
                if (this.canProcess(irecipe)) {
                    if (this.getClicks() > 0) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)MechanicalCentrifugeBlock.PROPERTY_ON, (Comparable)Boolean.valueOf(true)));
                    }
                    if (this.getClicks() >= 8) {
                        this.setClicks(0);
                        this.processItem(irecipe);
                        dirty = true;
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)MechanicalCentrifugeBlock.PROPERTY_ON, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.setClicks(0);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)MechanicalCentrifugeBlock.PROPERTY_ON, (Comparable)Boolean.valueOf(false)));
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    public boolean canProcess(@Nullable CentrifugeRecipe recipe) {
        if (recipe != null && !recipe.multiblock) {
            List<Pair<ItemStack, Float>> outputs = recipe.itemOutputs;
            ItemStack glassBottle = this.getItemStackHandler().getStackInSlot(1);
            ItemStack combs = this.getItemStackHandler().getStackInSlot(0);
            ItemStack[] stacks = recipe.ingredient.func_193365_a();
            int inputAmount = stacks.length == 1 ? stacks[0].func_190916_E() : 1;
            ArrayList<ItemStack> outputSlots = new ArrayList<ItemStack>(Arrays.asList(this.getItemStackHandler().getStackInSlot(3), this.getItemStackHandler().getStackInSlot(4), this.getItemStackHandler().getStackInSlot(2)));
            int processScore = 0;
            if (((ItemStack)outputSlots.get(0)).func_190926_b() && ((ItemStack)outputSlots.get(1)).func_190926_b() && ((ItemStack)outputSlots.get(2)).func_190926_b() && glassBottle.func_77973_b() == Items.field_151069_bo && combs.func_190916_E() >= inputAmount && glassBottle.func_190916_E() >= ((ItemStack)outputs.get(2).getLeft()).func_190916_E()) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if (!((ItemStack)outputSlots.get(i)).func_190926_b() && (((ItemStack)outputSlots.get(i)).func_77973_b() != ((ItemStack)outputs.get(i).getLeft()).func_77973_b() || ((ItemStack)outputSlots.get(i)).func_190916_E() + ((ItemStack)outputs.get(i).getLeft()).func_190916_E() > ((ItemStack)outputSlots.get(i)).func_77976_d())) continue;
                ++processScore;
            }
            if (combs.func_190916_E() >= inputAmount) {
                ++processScore;
            }
            if (processScore == 4 && glassBottle.func_77973_b() == Items.field_151069_bo && glassBottle.func_190916_E() >= ((ItemStack)outputs.get(2).getLeft()).func_190916_E()) {
                return true;
            }
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)MechanicalCentrifugeBlock.PROPERTY_ON, (Comparable)Boolean.valueOf(false)));
            }
            return false;
        }
        return false;
    }

    private void processItem(@Nullable CentrifugeRecipe recipe) {
        if (recipe != null && this.canProcess(recipe)) {
            ItemStack[] stacks = recipe.ingredient.func_193365_a();
            int inputAmount = stacks.length == 1 ? stacks[0].func_190916_E() : 1;
            ItemStack comb = this.getItemStackHandler().getStackInSlot(0);
            ItemStack glassBottle = this.getItemStackHandler().getStackInSlot(1);
            ArrayList<Pair> slots = new ArrayList<Pair>(Arrays.asList(Pair.of((Object)this.getItemStackHandler().getStackInSlot(3), (Object)3), Pair.of((Object)this.getItemStackHandler().getStackInSlot(4), (Object)4), Pair.of((Object)this.getItemStackHandler().getStackInSlot(2), (Object)2)));
            if (this.field_145850_b != null) {
                for (int i = 0; i < 3; ++i) {
                    Pair<ItemStack, Float> output = recipe.itemOutputs.get(i);
                    if (!((double)((Float)output.getRight()).floatValue() >= this.field_145850_b.field_73012_v.nextDouble())) continue;
                    if (((ItemStack)((Pair)slots.get(i)).getLeft()).func_190926_b()) {
                        this.getItemStackHandler().setStackInSlot((Integer)((Pair)slots.get(i)).getRight(), ((ItemStack)output.getLeft()).func_77946_l());
                    } else if (((ItemStack)((Pair)slots.get(i)).getLeft()).func_77973_b() == ((ItemStack)output.getLeft()).func_77973_b()) {
                        ((ItemStack)((Pair)slots.get(i)).getLeft()).func_190917_f(((ItemStack)output.getLeft()).func_190916_E());
                    }
                    if (!((Integer)((Pair)slots.get(i)).getRight()).equals(2)) continue;
                    glassBottle.func_190918_g(((ItemStack)output.getLeft()).func_190916_E());
                }
            }
            comb.func_190918_g(inputAmount);
        }
        this.setClicks(0);
    }

    public CentrifugeRecipe getRecipe() {
        ItemStack input = this.getItemStackHandler().getStackInSlot(0);
        if (input.func_190926_b() || input == this.getFailedMatch() || this.field_145850_b == null) {
            return null;
        }
        if (this.recipe == null || !this.recipe.func_77569_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)this.getItemStackHandler()), this.field_145850_b)) {
            CentrifugeRecipe rec = this.field_145850_b.func_199532_z().func_215371_a(CentrifugeRecipe.CENTRIFUGE_RECIPE_TYPE, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.getItemStackHandler()), this.field_145850_b).orElse(null);
            this.setFailedMatch(rec == null ? input : ItemStack.field_190927_a);
            this.recipe = rec;
        }
        return this.recipe;
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getItemStackHandler().deserializeNBT(invTag);
        this.setClicks(tag.func_74762_e("clicks"));
        super.func_230337_a_(state, tag);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT inv = this.getItemStackHandler().serializeNBT();
        tag.func_218657_a("inv", (INBT)inv);
        tag.func_74768_a("clicks", this.getClicks());
        return super.func_189515_b(tag);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.getAutomationHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.lazyOptional.invalidate();
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation && (slot == 0 || slot == 1);
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 2 || slot == 3 || slot == 4;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        return new MechanicalCentrifugeContainer(id, this.field_145850_b, this.field_174879_c, playerInventory);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.mechanical_centrifuge");
    }

    @NotNull
    public AutomationSensitiveItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public LazyOptional<IItemHandler> getAutomationHandler() {
        return this.automationHandler;
    }

    public int getClicks() {
        return this.clicks;
    }

    public void setClicks(int clicks) {
        this.clicks = clicks;
    }

    public void setRecipe(CentrifugeRecipe recipe) {
        this.recipe = recipe;
    }

    public ItemStack getFailedMatch() {
        return this.failedMatch;
    }

    public void setFailedMatch(ItemStack failedMatch) {
        this.failedMatch = failedMatch;
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots, AutomationSensitiveItemStackHandler.IAcceptor acceptor, AutomationSensitiveItemStackHandler.IRemover remover) {
            super(slots, acceptor, remover);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MechanicalCentrifugeTileEntity.this.func_70296_d();
        }
    }
}

