/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.HoneyTankContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.SyncGUIMessage;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.AbstractHoneyTankContainer;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyTankTileEntity
extends AbstractHoneyTankContainer {
    public static final int BOTTLE_INPUT_FILL = 2;
    public static final int BOTTLE_OUTPUT_FILL = 3;
    private int processingFill = 0;
    public static final Logger LOGGER = LogManager.getLogger();
    private TankTier tier;

    public HoneyTankTileEntity(TankTier tier) {
        super((TileEntityType)ModTileEntityTypes.HONEY_TANK_TILE_ENTITY.get(), tier.maxFillAmount);
        this.setTier(tier);
        this.setTileStackHandler(new TileStackHandler(4, this.getAcceptor(), this.getRemover()));
    }

    public TankTier getTier() {
        return this.tier;
    }

    public void setTier(TankTier tier) {
        this.tier = tier;
    }

    public float getProcessFillPercent() {
        if (!this.canProcessFill()) {
            return 0.0f;
        }
        if (this.processingFill == (Integer)Config.HONEY_PROCEESS_TIME.get()) {
            return 1.0f;
        }
        return (float)this.processingFill / (float)((Integer)Config.HONEY_PROCEESS_TIME.get()).intValue();
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.honey_tank");
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inventory, @NotNull PlayerEntity player) {
        if (this.field_145850_b == null) {
            return null;
        }
        return new HoneyTankContainer(id, this.field_145850_b, this.field_174879_c, inventory);
    }

    public boolean canProcessFill() {
        Item outputItem;
        ItemStack stack = this.getTileStackHandler().getStackInSlot(2);
        FluidStack fluidStack = this.getFluidTank().getFluid();
        ItemStack outputStack = this.getTileStackHandler().getStackInSlot(3);
        boolean isBottle = stack.func_77973_b() == Items.field_151069_bo;
        Item item = outputItem = isBottle ? BeeInfoUtils.getHoneyBottle(fluidStack.getFluid()) : BeeInfoUtils.getHoneyBucket(fluidStack.getFluid());
        boolean isTankReady = !fluidStack.isEmpty() && this.getFluidTank().getFluidAmount() >= (isBottle ? 250 : 1000);
        boolean hasInput = !stack.func_190926_b();
        boolean canOutput = outputStack.func_190926_b() || outputStack.func_77973_b() == outputItem && outputStack.func_190916_E() < outputStack.func_77976_d();
        return isTankReady && hasInput && canOutput;
    }

    public void processFill() {
        ItemStack inputStack = this.getTileStackHandler().getStackInSlot(2);
        boolean isBottle = true;
        if (inputStack.func_77973_b() == Items.field_151133_ar) {
            isBottle = false;
        }
        inputStack.func_190918_g(1);
        FluidStack fluidStack = new FluidStack(this.getFluidTank().getFluid(), isBottle ? 250 : 1000);
        this.getTileStackHandler().setStackInSlot(2, inputStack);
        ItemStack outputStack = this.getTileStackHandler().getStackInSlot(3);
        if (outputStack.func_190926_b()) {
            outputStack = isBottle ? new ItemStack((IItemProvider)BeeInfoUtils.getHoneyBottle(fluidStack.getFluid())) : new ItemStack((IItemProvider)BeeInfoUtils.getHoneyBucket(fluidStack.getFluid()));
        } else {
            outputStack.func_190917_f(1);
        }
        this.getTileStackHandler().setStackInSlot(3, outputStack);
        this.getFluidTank().drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 || slot == 2;
    }

    @Override
    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 3;
    }

    @Override
    public void func_73660_a() {
        if (this.canProcessFill()) {
            if (this.processingFill >= (Integer)Config.HONEY_PROCEESS_TIME.get()) {
                this.processFill();
                this.processingFill = 0;
            }
            ++this.processingFill;
        }
        super.func_73660_a();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177977_b().func_177968_d().func_177976_e(), this.func_174877_v().func_177984_a().func_177978_c().func_177974_f());
    }

    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.writeFluidStack(this.getFluidTank().getFluid());
            NetPacketHandler.sendToPlayer(new SyncGUIMessage(this.field_174879_c, buffer), (ServerPlayerEntity)player);
        }
    }

    public void handleGUINetworkPacket(PacketBuffer buffer) {
        this.getFluidTank().setFluid(buffer.readFluidStack());
    }

    @Override
    public CompoundNBT writeNBT(CompoundNBT tag) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        tag.func_218657_a("inv", (INBT)inv);
        tag.func_74768_a("tier", this.getTier().tier);
        if (this.getFluidTank().isEmpty()) {
            return tag;
        }
        return super.writeNBT(tag);
    }

    @Override
    public void readNBT(CompoundNBT tag) {
        super.readNBT(tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
        this.setTier(TankTier.getTier(tag.func_74762_e("tier")));
        if (this.getFluidTank().getTankCapacity(0) != this.getTier().maxFillAmount) {
            this.getFluidTank().setCapacity(this.getTier().maxFillAmount);
        }
        if (this.getFluidTank().getFluidAmount() > this.getFluidTank().getTankCapacity(0)) {
            this.getFluidTank().getFluid().setAmount(this.getFluidTank().getTankCapacity(0));
        }
    }

    protected class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots, AutomationSensitiveItemStackHandler.IAcceptor acceptor, AutomationSensitiveItemStackHandler.IRemover remover) {
            super(slots, acceptor, remover);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            HoneyTankTileEntity.this.func_70296_d();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            boolean slot0Valid = slot == 0 && AbstractHoneyTankContainer.isItemValid(stack);
            boolean slot2Valid = slot == 2 && (stack.func_77973_b() == Items.field_151069_bo || stack.func_77973_b() == Items.field_151133_ar);
            return slot0Valid || slot2Valid;
        }
    }

    public static enum TankTier {
        PURPUR(3, 128000, ModBlocks.PURPUR_HONEY_TANK, ModItems.PURPUR_HONEY_TANK_ITEM),
        NETHER(2, 32000, ModBlocks.NETHER_HONEY_TANK, ModItems.NETHER_HONEY_TANK_ITEM),
        WOODEN(1, 8000, ModBlocks.WOODEN_HONEY_TANK, ModItems.WOODEN_HONEY_TANK_ITEM);

        private final RegistryObject<Block> tankBlock;
        private final RegistryObject<Item> tankItem;
        int maxFillAmount;
        int tier;

        private TankTier(int tier, int maxFillAmount, RegistryObject<Block> tankBlock, RegistryObject<Item> tankItem) {
            this.tier = tier;
            this.maxFillAmount = maxFillAmount;
            this.tankBlock = tankBlock;
            this.tankItem = tankItem;
        }

        public static TankTier getTier(Item item) {
            for (TankTier t : TankTier.values()) {
                if (t.tankItem.get() != item) continue;
                return t;
            }
            return WOODEN;
        }

        public RegistryObject<Block> getTankBlock() {
            return this.tankBlock;
        }

        public RegistryObject<Item> getTankItem() {
            return this.tankItem;
        }

        public int getTier() {
            return this.tier;
        }

        public int getMaxFillAmount() {
            return this.maxFillAmount;
        }

        public static TankTier getTier(int tier) {
            for (TankTier t : TankTier.values()) {
                if (t.tier != tier) continue;
                return t;
            }
            return WOODEN;
        }
    }
}

