/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.tileentity;

import com.resourcefulbees.resourcefulbees.block.HoneyGenerator;
import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.container.HoneyGeneratorContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.SyncGUIMessage;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.AbstractHoneyTankContainer;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyGeneratorTileEntity
extends AbstractHoneyTankContainer
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int HONEY_BOTTLE_INPUT = 0;
    public static final int BOTTLE_OUTPUT = 1;
    public static final int HONEY_DRAIN_AMOUNT = (Integer)Config.HONEY_DRAIN_AMOUNT.get();
    public static final int ENERGY_FILL_AMOUNT = (Integer)Config.ENERGY_FILL_AMOUNT.get();
    public static final int ENERGY_TRANSFER_AMOUNT = (Integer)Config.ENERGY_TRANSFER_AMOUNT.get();
    public static final int MAX_ENERGY_CAPACITY = (Integer)Config.MAX_ENERGY_CAPACITY.get();
    public static final int MAX_TANK_STORAGE = (Integer)Config.MAX_TANK_STORAGE.get();
    private final TileStackHandler tileStackHandler = new TileStackHandler(5, this.getAcceptor(), this.getRemover());
    private final CustomEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getTileStackHandler);
    private final LazyOptional<IEnergyStorage> energyOptional = LazyOptional.of(() -> this.energyStorage);
    public static final ITag<Fluid> HONEY_FLUID_TAG = BeeInfoUtils.getFluidTag("resourcefulbees:resourceful_honey");
    public static final ITag<Item> HONEY_BOTTLE_TAG = BeeInfoUtils.getItemTag("resourcefulbees:resourceful_honey_bottle");
    private int fluidFilled;
    private int energyFilled;
    private boolean isProcessing;

    public HoneyGeneratorTileEntity() {
        super((TileEntityType)ModTileEntityTypes.HONEY_GENERATOR_ENTITY.get(), MAX_TANK_STORAGE);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.getFluidTank().isEmpty() && this.canProcessEnergy()) {
                this.processEnergy();
            }
            if (!this.isProcessing && !this.canProcessEnergy()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)HoneyGenerator.PROPERTY_ON, (Comparable)Boolean.valueOf(false)));
            }
            super.func_73660_a();
        }
        this.sendOutPower();
    }

    private void sendOutPower() {
        if (this.getStoredEnergy() > 0 && this.field_145850_b != null) {
            Arrays.stream(Direction.values()).map(direction -> Pair.of((Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction)), (Object)direction)).filter(pair -> pair.getLeft() != null && pair.getRight() != null).forEach(this::transferEnergy);
        }
    }

    private void transferEnergy(Pair<TileEntity, Direction> tileEntityDirectionPair) {
        ((TileEntity)tileEntityDirectionPair.getLeft()).getCapability(CapabilityEnergy.ENERGY, ((Direction)tileEntityDirectionPair.getRight()).func_176734_d()).filter(IEnergyStorage::canReceive).ifPresent(this::transferEnergy);
    }

    private void transferEnergy(IEnergyStorage handler) {
        if (this.getStoredEnergy() > 0) {
            int received = handler.receiveEnergy(Math.min(this.getStoredEnergy(), ENERGY_TRANSFER_AMOUNT), false);
            this.energyStorage.consumeEnergy(received);
        }
    }

    private int getStoredEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public boolean canProcessEnergy() {
        return this.getStoredEnergy() + ENERGY_FILL_AMOUNT <= this.energyStorage.getMaxEnergyStored() && this.getFluidTank().getFluidAmount() >= HONEY_DRAIN_AMOUNT;
    }

    private void processEnergy() {
        if (this.canProcessEnergy()) {
            this.getFluidTank().drain(HONEY_DRAIN_AMOUNT, IFluidHandler.FluidAction.EXECUTE);
            this.energyStorage.addEnergy(ENERGY_FILL_AMOUNT);
            this.setEnergyFilled(this.getEnergyFilled() + ENERGY_FILL_AMOUNT);
            if (this.getEnergyFilled() >= ENERGY_FILL_AMOUNT) {
                this.setEnergyFilled(0);
            }
            assert (this.field_145850_b != null) : "World is null?";
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)HoneyGenerator.PROPERTY_ON, (Comparable)Boolean.valueOf(true)));
            this.setDirty();
        }
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("tank", (INBT)this.getFluidTank().writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("power", (INBT)this.energyStorage.serializeNBT());
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.getFluidTank().readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.deserializeNBT(nbt.func_74775_l("power"));
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        tag.func_218657_a("inv", (INBT)inv);
        tag.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        tag.func_218657_a("fluid", (INBT)this.getFluidTank().writeToNBT(new CompoundNBT()));
        tag.func_74768_a("energyFilled", this.getEnergyFilled());
        tag.func_74768_a("fluidFilled", this.getFluidFilled());
        tag.func_74757_a("isProcessing", this.isProcessing);
        return super.func_189515_b(tag);
    }

    @Override
    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    @Override
    public void func_230337_a_(@NotNull BlockState state, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
        this.energyStorage.deserializeNBT(tag.func_74775_l("energy"));
        this.getFluidTank().readFromNBT(tag.func_74775_l("fluid"));
        if (tag.func_74764_b("energyFilled")) {
            this.setEnergyFilled(tag.func_74762_e("energyFilled"));
        }
        if (tag.func_74764_b("fluidFilled")) {
            this.setFluidFilled(tag.func_74762_e("fluidFilled"));
        }
        if (tag.func_74764_b("isProcessing")) {
            this.isProcessing = tag.func_74767_n("isProcessing");
        }
        super.func_230337_a_(state, tag);
    }

    @Override
    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.lazyOptional.cast();
        }
        if (cap.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.energyOptional.cast();
        }
        if (cap.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.getFluidOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void invalidateCaps() {
        this.lazyOptional.invalidate();
        this.energyOptional.invalidate();
        this.getFluidOptional().invalidate();
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        return new HoneyGeneratorContainer(id, this.field_145850_b, this.field_174879_c, playerInventory);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.resourcefulbees.honey_generator");
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(MAX_ENERGY_CAPACITY, 0, ENERGY_TRANSFER_AMOUNT){

            @Override
            protected void onEnergyChanged() {
                HoneyGeneratorTileEntity.this.func_70296_d();
            }
        };
    }

    public void sendGUINetworkPacket(IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.writeFluidStack(this.getFluidTank().getFluid());
            buffer.writeInt(this.energyStorage.getEnergyStored());
            NetPacketHandler.sendToPlayer(new SyncGUIMessage(this.field_174879_c, buffer), (ServerPlayerEntity)player);
        }
    }

    public void handleGUINetworkPacket(PacketBuffer buffer) {
        this.getFluidTank().setFluid(buffer.readFluidStack());
        this.energyStorage.setEnergy(buffer.readInt());
    }

    @Override
    @NotNull
    public TileStackHandler getTileStackHandler() {
        return this.tileStackHandler;
    }

    public int getFluidFilled() {
        return this.fluidFilled;
    }

    public void setFluidFilled(int fluidFilled) {
        this.fluidFilled = fluidFilled;
    }

    public int getEnergyFilled() {
        return this.energyFilled;
    }

    public void setEnergyFilled(int energyFilled) {
        this.energyFilled = energyFilled;
    }

    public CustomEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        protected TileStackHandler(int slots, AutomationSensitiveItemStackHandler.IAcceptor acceptor, AutomationSensitiveItemStackHandler.IRemover remover) {
            super(slots, acceptor, remover);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.func_77973_b() instanceof BucketItem) {
                BucketItem bucket = (BucketItem)stack.func_77973_b();
                return bucket.getFluid().func_207185_a(HONEY_FLUID_TAG);
            }
            return stack.func_77973_b().func_206844_a(HONEY_BOTTLE_TAG);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            HoneyGeneratorTileEntity.this.func_70296_d();
        }
    }
}

